/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.Nullable;

import com.clustercontrol.cloud.cloudn.rest.api.CloudnEndpoint;
import com.clustercontrol.cloud.cloudn.rest.api.DirectParam;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;

public interface CloudnCompute extends CloudnEndpoint {
	ListZonesResponse listZones() throws RestfulApplicationException;
	ListZonesResponse listZones(ListZonesRequest request) throws RestfulApplicationException;

	ListServiceOfferingsResponse listServiceOfferings(ListServiceOfferingsRequest request) throws RestfulApplicationException;
	ListServiceOfferingsResponse listServiceOfferings() throws RestfulApplicationException;
	ListDiskOfferingsResponse listDiskOfferings(ListDiskOfferingsRequest request) throws RestfulApplicationException;
	ListDiskOfferingsResponse listDiskOfferings() throws RestfulApplicationException;

	ListVirtualMachinesResponse listVirtualMachines() throws RestfulApplicationException;
	ListVirtualMachinesResponse listVirtualMachines(ListVirtualMachinesRequest request) throws RestfulApplicationException;

	CreateTagsResponse createTags(CreateTagsRequest request) throws RestfulApplicationException;
	ListTagsResponse listTags() throws RestfulApplicationException;
	
	StartVirtualMachineResponse startVirtualMachine(@DirectParam(name="id") String id) throws RestfulApplicationException;
	StopVirtualMachineResponse stopVirtualMachine(@DirectParam(name="id") String id) throws RestfulApplicationException;
	StopVirtualMachineResponse stopVirtualMachine(@DirectParam(name="id") String id, @DirectParam(name="forced") @Nullable String forced) throws RestfulApplicationException;
	DeployVirtualMachineResponse deployVirtualMachine(DeployVirtualMachineRequest request) throws RestfulApplicationException;
	DestroyVirtualMachineResponse destroyVirtualMachine(@DirectParam(name="id") String id) throws RestfulApplicationException;

	ListVolumesResponse listVolumes(@Nullable ListVolumesRequest request) throws RestfulApplicationException;
	ListVolumesResponse listVolumes() throws RestfulApplicationException;
	AttachVolumeResponse attachVolume(@DirectParam(name="id") String volumeId, @DirectParam(name="virtualmachineid") String virtualMachineId) throws RestfulApplicationException;
	DetachVolumeResponse detachVolume(DetachVolumeRequest request) throws RestfulApplicationException;
	CreateVolumeResponse createVolume(CreateVolumeRequest request) throws RestfulApplicationException;
	DeleteVolumeResponse deleteVolume(@DirectParam(name="id") String id) throws RestfulApplicationException;

	ListSnapshotsResponse listSnapshots(@Nullable ListSnapshotsRequest request) throws RestfulApplicationException;
	ListSnapshotsResponse listSnapshots() throws RestfulApplicationException;
	CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) throws RestfulApplicationException;
	DeleteSnapshotResponse deleteSnapshot(@DirectParam(name="id") String id, @DirectParam(name="zoneid") @Nullable String zoneId) throws RestfulApplicationException;
	
	ListNetworksResponse listNetworks() throws RestfulApplicationException;
	
	CreateTemplateResponse createTemplate(CreateTemplateRequest request) throws RestfulApplicationException;
	ListTemplatesResponse listTemplates(ListTemplateRequest request) throws RestfulApplicationException;
	DeleteTemplateResponse deleteTemplate(@DirectParam(name="id") String id, @Nullable @DirectParam(name="zoneid") String zoneid) throws RestfulApplicationException;
	CopyTemplateResponse copyTemplate(CopyTemplateRequest request);

	CreateSSHKeyPairResponse createSSHKeyPair(@DirectParam(name="name") String name) throws RestfulApplicationException;
	String listSSHKeyPairs() throws RestfulApplicationException;
	String deleteSSHKeyPair(@DirectParam(name="name") String name) throws RestfulApplicationException;

	ListOSTypesResponse listOsTypes() throws RestfulApplicationException;
	ListOSTypesResponse listOsTypes(ListOsTypesRequest request) throws RestfulApplicationException;
	
	ResetPasswordForVirtualMachineResponse resetPasswordForVirtualMachine(@DirectParam(name="id") String id) throws RestfulApplicationException;
	
	ListPublicIpAddressesResponse listPublicIpAddresses(ListPublicIpAddressesRequest request) throws RestfulApplicationException;
	ListPublicIpAddressesResponse listPublicIpAddresses() throws RestfulApplicationException;
	
	QueryAsyncJobResultResponse queryAsyncJobResult(@DirectParam(name="jobid") String jobId) throws RestfulApplicationException;
	
	ListApisResponse listApis() throws RestfulApplicationException;
	ListApisResponse listApis(@DirectParam(name="name") String name) throws RestfulApplicationException;

	ListApisResponse reset(@DirectParam(name="name") String name) throws RestfulApplicationException;
	
	//FLAT
	ListSecurityGroupsResponse listSecurityGroups(@Nullable ListSecurityGroupsRequest request) throws RestfulApplicationException;
}