/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListSnapshotsRequest extends RestApplicationRequest {
	// 指定したアカウントに属する情報に絞り込む。domainidと同時に利用する 
	public String account;

	// ドメインIDを指定する。指定することにより、指定したドメイン以下の情報に絞り込む
	public String domainid;

	// スナップショットID を指定する
	public String id;
	
	// 定期スナップショットの場合の取得間隔を指定する (WEEKLY, MONTHLY.)
	public String intervaltype;
	
	// サブドメインが保有するDisk Voluneも検索対象とする
	public Boolean isrecursive;

	// キーワードによる検索を実施する
	public String keyword;

	// true/ falseで指定する(default false). zoneidとisrecursive=trueと設定した場合に等しい
	public Boolean listall;

	// スナップショット名を指定する
	public String name;

	// pagesizeと同時に指定して、ページ番号を指定する 
	public Integer page;

	// 一度のリクエストに含めるレスポンス(非同期ジョブ)の個数を指定する。pageと同時にしていする.(default:500) 
	public Integer pagesize;

	// スナップショットタイプを指定する 
	public String snapshottype;

	// ディスクボリュームIDを指定する 
	public String volumeid;
	
	public String zoneid;

	public ListSnapshotsRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}
	
	public ListSnapshotsRequest withVolumeId(@NonNull String volumeid) {
		Preconditions.checkNotNull(volumeid);
		this.volumeid = volumeid;
		return this;
	}
}
