/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@XmlRootElement(name="tag")
public class RTag {
	public String key;
	public String value = "";
	
	public RTag() {
	}
	public RTag(String key, String value) {
		this.key = key;
		this.value = value;
	}
	public RTag withKey(@NonNull String key) {
		Preconditions.checkNotNull(key);
		this.key = key;
		return this;
	}
	public RTag withValue(@NonNull String value) {
		Preconditions.checkNotNull(key);
		this.value = value;
		return this;
	}
}
