/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;

import com.clustercontrol.cloud.Messages;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;

public class CloudnRestfulApplicationError {
	private static final List<CloudnRestfulApplicationError> errors = new ArrayList<>();

	public static final CloudnRestfulApplicationError Signature_FailToMakeSignature = new CloudnRestfulApplicationError("Cloudn.Signature.FailToMakeSignature");
	public static final CloudnRestfulApplicationError Params_FailToMakeParamString = new CloudnRestfulApplicationError("Cloudn.Params.FailToMakeParamString");
	public static final CloudnRestfulApplicationError Params_NotInitialiseMarshaller = new CloudnRestfulApplicationError("Cloudn.Params.NotInitialiseMarshaller");
	public static final CloudnRestfulApplicationError Params_NeedParamAnotation = new CloudnRestfulApplicationError("Cloudn.Params.NeedParamAnotation");
	public static final CloudnRestfulApplicationError Endpoint_Unset = new CloudnRestfulApplicationError("Cloudn.Endpoint.Unset");
	public static final CloudnRestfulApplicationError Request_ProcessingError = new CloudnRestfulApplicationError("Cloudn.Request.ProcessingError");

	private final String errorCode;
	
	public CloudnRestfulApplicationError(String errorCode) {
		this.errorCode = errorCode;
		errors.add(this);
	}
	
	public String getMessage(Object... args) {
		MessageFormat messageFormat = new MessageFormat(getMessage());
		return messageFormat.format(args);
	}

	public ImmutableList<CloudnRestfulApplicationError> getErrors() {
		Builder<CloudnRestfulApplicationError> builder = ImmutableList.builder();
		return builder.addAll(errors).build();
	}

	public String errorCode() {
		return errorCode;
	}

	public boolean match(String errorCode) {
		return errorCode().equals(errorCode);
	}

	public boolean match(RestfulApplicationException e) {
		return errorCode().equals(e.getErrorCode());
	}

	public String getMessage() {
		try {
			return Messages.messages().getString(errorCode());
		}
		catch (MissingResourceException e) {
			return errorCode();
		}
	}

	public RestfulApplicationException restRequestException(int statusCode, String detailCode, String requestUrl, String reason, Exception e, Object... args) {
		return new RestfulApplicationException(errorCode(), statusCode, detailCode, requestUrl, reason, e);
	}

	public RestfulApplicationException exceptionException(Exception e, Object... args) {
		return new RestfulApplicationException(errorCode(), getMessage(args), e);
	}

	public RestfulApplicationException exceptionException(String message, Exception e) {
		return new RestfulApplicationException(errorCode(), e.getMessage(), e);
	}

	public RestfulApplicationException exception(Object... args) {
		return new RestfulApplicationException(errorCode(), getMessage(args));
	}
}