/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import org.eclipse.jdt.annotation.Nullable;


public class RestfulApplicationException extends RuntimeException {
	/**
	 */
	private static final long serialVersionUID = -4480048021892941250L;
	
	private static final String UNEXPECTED = "UNEXPECTED";

	/** The HTTP status code that was returned with this error */
	private String errorCode = UNEXPECTED;

	@Nullable
	private Integer statusCode = null;
	@Nullable
	private String detailCode = null;
	@Nullable
	private String requestUrl = null;
	@Nullable 
	private String reason = null;

	public RestfulApplicationException() {
	}

	public RestfulApplicationException(String message) {
		super(message);
	}

	public RestfulApplicationException(String errorCode, Throwable cause) {
		super(cause);
		setErrorCode(errorCode);
	}

	public RestfulApplicationException(String errorCode, String message) {
		super(message);
		setErrorCode(errorCode);
	}

	public RestfulApplicationException(String errorCode, String message, Throwable cause) {
		super(message, cause);
		setErrorCode(errorCode);
	}

	public RestfulApplicationException(String errorCode, @Nullable Integer statusCode, @Nullable String detailCode, @Nullable String requestUrl, @Nullable String reason, Throwable cause) {
		super(cause);
		setErrorCode(errorCode);
		setStatusCode(statusCode);
		setDetailCode(detailCode);
		setRequestUrl(requestUrl);
		setReason(reason);
	}

	private void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}

	@Override
	public String getMessage() {
		String s = getMessageWithoutErrorCode() + ", " + "ErrorCode=" + errorCode;
		return s;
	}

	public String getMessageWithoutErrorCode() {
		String s = super.getMessage() + " : " + 
				(statusCode == null ? "": (", " + "statusCode=" + statusCode)) + 
				(detailCode == null ? "": (", " + "detailCode=" + detailCode)) + 
				(reason == null ? "": (", " + "reason=" + reason)) + 
				(requestUrl == null ? "": (", " + "requestUrl=" + requestUrl));
		return s;
	}

	public String getUndecoratedMessage() {
		return super.getMessage();
	}

	public @Nullable Integer getStatusCode() {
		return statusCode;
	}

	private void setStatusCode(@Nullable Integer statusCode) {
		this.statusCode = statusCode;
	}

	public @Nullable String getReason() {
		return reason;
	}

	private void setReason(@Nullable String reason) {
		this.reason = reason;
	}

	public @Nullable String getRequestUrl() {
		return requestUrl;
	}

	private void setRequestUrl(@Nullable String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public @Nullable String getDetailCode() {
		return detailCode;
	}

	private void setDetailCode(@Nullable String detailCode) {
		this.detailCode = detailCode;
	}
}