/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.util;

import java.util.List;

import javax.persistence.Query;

import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.util.AuthorizingUtil;

public class AuthorizingUtilEx extends AuthorizingUtil {
	private AuthorizingUtilEx(){};
	
	public static boolean checkHinemousUser_cloudServiceId(String hinemousUserId, String cloudServiceId) throws CloudManagerFault {
		return !getCloudUsersByCloudService(hinemousUserId, cloudServiceId).isEmpty();
	}

	@SuppressWarnings("unchecked")
	public static List<CloudUserDao> getCloudUsersByCloudService(String hinemousUserId, String cloudServiceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a " + 
				"WHERE a.cloudServiceId = :cloudServiceId " +
				"AND (u.userId = :userId OR EXISTS (SELECT u FROM UserEntity u JOIN u.roleEntities r WHERE u.userId = :userId AND r.roleId = :ADMINISTRATORS))"
				);
		query.setParameter("userId", hinemousUserId);
		query.setParameter("cloudServiceId", cloudServiceId);
		query.setParameter("ADMINISTRATORS", RoleIdConstant.ADMINISTRATORS);
		return (List<CloudUserDao>)query.getResultList();
	}
}