/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;


public interface IUserManagement {
	public interface ICredential {
	    public String getAccessKey();
	    public String getSecretKey();
	}

	public static class Credential implements ICredential{
		private String accessKey;
		private String secretKey;
		
		public Credential(String accessKey, String secretKey) {
			this.accessKey = accessKey;
			this.secretKey = secretKey;
		}
	    public String getAccessKey() {
	    	return accessKey;
	    }
	    public String getSecretKey() {
	    	return secretKey;
	    }
	}

	public static class User {
		public static enum UserKind {
			account,
			user
		}
		private String name;
		private UserKind kind;

		public User(String name, UserKind kind) {
			this.name = name;
			this.kind = kind;
		}
		
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public UserKind getKind() {
			return kind;
		}
		public void setKind(UserKind kind) {
			this.kind = kind;
		}
	}

	void setCredential(ICredential credential);
	
	// ユーザー
	User getCurrentUser() throws CloudManagerFault;
}
