/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * ノード登録情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#registNode(RegistNodeRequest request) registNode 関数} にて使用される。
 *
 */
public class RegistNodeRequest {
	private NodeDetail nodeDetail;
	private String instanceId;

	/**
	 * ノード作成に必要な情報を返す。
	 * 
	 * @return ノード作成情報。
	 */
	@ElementId("NodeDetail")
	@Into
	@NotNull
	public NodeDetail getNodeDetail() {
		return nodeDetail;
	}
	/**
	 * ノード作成情報を指定する。
	 * 
	 * @param nodeDetail ノード作成情報。
	 */
	public void setNodeDetail(NodeDetail nodeDetail) {
		this.nodeDetail = nodeDetail;
	}
	
	/**
	 * インスタンス Id を取得する。
	 * 
	 * @return インスタンス Id
	 */
	@ElementId("instanceId")
	@NotNull
	@Size(max=64)
	public String getInstanceId() {
		return instanceId;
	}
	/**
	 * インスタンス Id を指定する。
	 * 
	 * @param instanceId　インスタンス Id
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
}