/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;


/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_user")
public class CloudUserDao extends HinemosObjectDao {
	public static enum CloudUserType {
		account,
		user
	}
	
	private String cloudUserId;
	private String cloudUserName;
	private CloudAccountResourceDao accountResource;
	private String description;
	private String accessKey;
	private String secretKey;
	private String secretKeyCrypt;
	private CloudUserType cloudUserType;
	private String roleId;

	public CloudUserDao()
	{
	}

	public CloudUserDao( String cloudUserId,String cloudUserName,CloudAccountResourceDao accountResource,String description,String accessKey,String secretKey,String secretKeyCrypt,String cloudId,CloudUserType cloudUserType,String roleId,Timestamp regDate,Timestamp updateDate,String regUser,String updateUser )
	{
		super(regDate, updateDate, regUser, updateUser);
		setCloudUserId(cloudUserId);
		setCloudUserName(cloudUserName);
		setAccountResource(accountResource);
		setDescription(description);
		setAccessKey(accessKey);
		setSecretKey(secretKey);
		setSecretKeyCrypt(secretKeyCrypt);
		setCloudUserType(cloudUserType);
		setRoleId(roleId);
	}

	public CloudUserDao( CloudUserDao otherData )
	{
		super(otherData);
		setCloudUserId(otherData.getCloudUserId());
		setCloudUserName(otherData.getCloudUserName());
		setAccountResource(otherData.getAccountResource());
		setAccessKey(otherData.getAccessKey());
		setSecretKey(otherData.getSecretKey());
		setSecretKeyCrypt(otherData.getSecretKeyCrypt());
		setDescription(otherData.getDescription());
		setCloudUserType(otherData.getCloudUserType());
		setRoleId(otherData.getRoleId());
	}

	@Column(name="cloud_user_id")
	@Id
	public String getCloudUserId()
	{
		return this.cloudUserId;
	}
	public void setCloudUserId( String cloudUserId )
	{
		this.cloudUserId = cloudUserId;
	}

	@Column(name="cloud_user_name")
	public String getCloudUserName()
	{
		return this.cloudUserName;
	}
	public void setCloudUserName( String cloudUserName )
	{
		this.cloudUserName = cloudUserName;
	}

	@JoinColumn(name="account_resource_id")
	public CloudAccountResourceDao getAccountResource()
	{
		return accountResource;
	}
	public void setAccountResource( CloudAccountResourceDao accountResource )
	{
		this.accountResource = accountResource;
	}

	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription( String description )
	{
		this.description = description;
	}

	@Column(name="access_key")
	public String getAccessKey()
	{
		return this.accessKey;
	}
	public void setAccessKey( String accessKey )
	{
		this.accessKey = accessKey;
	}

	@Transient
	@Cryption("secretKeyCrypt")
	public String getSecretKey()
	{
		return this.secretKey;
	}
	public void setSecretKey( String secretKey )
	{
		this.secretKey = secretKey;
	}

	@Column(name="secret_key")
	public String getSecretKeyCrypt()
	{
		return this.secretKeyCrypt;
	}
	public void setSecretKeyCrypt( String secretKeyCrypt )
	{
		this.secretKeyCrypt = secretKeyCrypt;
	}

	@Column(name="cloud_user_type")
	@Enumerated(EnumType.STRING)
	public CloudUserType getCloudUserType()
	{
		return this.cloudUserType;
	}
	public void setCloudUserType( CloudUserType cloudUserType )
	{
		this.cloudUserType = cloudUserType;
	}

	@Column(name="role_id")
	public String getRoleId()
	{
		return this.roleId;
	}
	public void setRoleId( String roleId )
	{
		this.roleId = roleId;
	}

	@Override
	public String toString() {
		return "CloudUserDao [cloudUserId=" + cloudUserId + ", cloudUserName="
				+ cloudUserName + ", accountResource=" + accountResource
				+ ", description=" + description + ", accessKey=" + accessKey
				+ ", secretKey=" + secretKey + ", secretKeyCrypt="
				+ secretKeyCrypt + ", cloudUserType=" + cloudUserType
				+ ", roleId=" + roleId + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudUserDao other = (CloudUserDao) obj;
		if (accessKey == null) {
			if (other.accessKey != null)
				return false;
		} else if (!accessKey.equals(other.accessKey))
			return false;
		if (accountResource == null) {
			if (other.accountResource != null)
				return false;
		} else if (!accountResource.equals(other.accountResource))
			return false;
		if (cloudUserId == null) {
			if (other.cloudUserId != null)
				return false;
		} else if (!cloudUserId.equals(other.cloudUserId))
			return false;
		if (cloudUserName == null) {
			if (other.cloudUserName != null)
				return false;
		} else if (!cloudUserName.equals(other.cloudUserName))
			return false;
		if (cloudUserType != other.cloudUserType)
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (roleId == null) {
			if (other.roleId != null)
				return false;
		} else if (!roleId.equals(other.roleId))
			return false;
		if (secretKey == null) {
			if (other.secretKey != null)
				return false;
		} else if (!secretKey.equals(other.secretKey))
			return false;
		if (secretKeyCrypt == null) {
			if (other.secretKeyCrypt != null)
				return false;
		} else if (!secretKeyCrypt.equals(other.secretKeyCrypt))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((accessKey == null) ? 0 : accessKey.hashCode());
		result = prime * result
				+ ((accountResource == null) ? 0 : accountResource.hashCode());
		result = prime * result
				+ ((cloudUserId == null) ? 0 : cloudUserId.hashCode());
		result = prime * result
				+ ((cloudUserName == null) ? 0 : cloudUserName.hashCode());
		result = prime * result
				+ ((cloudUserType == null) ? 0 : cloudUserType.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((roleId == null) ? 0 : roleId.hashCode());
		result = prime * result
				+ ((secretKey == null) ? 0 : secretKey.hashCode());
		result = prime * result
				+ ((secretKeyCrypt == null) ? 0 : secretKeyCrypt.hashCode());
		return result;
	}

	@Override
	public String getId() {
		return getCloudUserId();
	}
}
