/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;
import java.util.Locale;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.cloud.validation.MethodValidator.MethodValidationContext;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.repository.bean.FacilityTreeItem;

public class AuthorizingValidator_facility implements CustomMethodValidator {
	@Override
	public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidationContext context) throws ValidationFault {
		try {
			FacilityTreeItem treeItem;
			try {
				treeItem = RepositoryControllerBeanWrapper.bean().getFacilityTree(null, Locale.getDefault());
			}
			catch (HinemosUnknown e1) {
				throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault(e1);
			}

			if (serarchFacility(treeItem, (String)params[0]) == null)
				throw ErrorCode.FACILITY_NOT_FOUND.cloudManagerFault((String)params[0]);
		}
		catch (CloudManagerFault e) {
			throw new ValidationFault(e);
		}
	}

	private FacilityTreeItem serarchFacility(FacilityTreeItem treeItem, String facilityId) {
		if (!treeItem.getData().isNotReferFlg() && treeItem.getData().getFacilityId().equals(facilityId)) return treeItem;
		
		for (FacilityTreeItem child: treeItem.getChildrenArray()) {
			FacilityTreeItem result = serarchFacility(child, facilityId);
			if (result != null)
				return result;
		}
		return null;
	}
}