SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_collector_sub_platform_mst (sub_platform_id, sub_platform_name, type, order_no) FROM stdin (DELIMITER ',');
cloudn_flat,Cloudn Flat,Cloud,111
cloudn_vpc,Cloudn VPC,Cloud,112
\.


--\set ON_ERROR_STOP

COPY cc_cloud_type_mst (cloud_id, cloud_name, description) FROM stdin (DELIMITER ',');
cloudn_flat,Cloudn Flat,Cloudn Flat
cloudn_vpc,Cloudn VPC,Cloudn VPC
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_service (cloud_service_id, cloud_service_name, cloud_type_id, description) FROM stdin (DELIMITER ',');
cloudn_flat,Bizホスティング Cloudn Flat タイプ,cloudn_flat,http://www.ntt.com/cloudn/ 
cloudn_vpc,Bizホスティング Cloudn VPC OpenNW タイプ,cloudn_vpc,http://www.ntt.com/cloudn/ 
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_region (region, cloud_service_id, region_name, description) FROM stdin (DELIMITER ',');
jp-e1,cloudn_flat,東日本,東日本DC
jp-e1,cloudn_vpc,東日本,東日本DC
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP
--\http://docs.aws.amazon.com/general/latest/gr/rande.html
COPY cc_cloud_endpoint (ep_type, cloud_service_id, region, location) FROM stdin (DELIMITER ',');
compute,cloudn_flat,jp-e1,comp-api.jp-e1.cloudn-service.com/client/api
compute,cloudn_vpc,jp-e1,vpcopennw-api.jp-e1.cloudn-service.com/client/api
\.

COMMIT;