/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudStorageManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.ICloudStorageManager;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudStorage;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class StoragesView
extends FilterlingViewPartByScopeTree<ICloudStorageManager, ICloudStorage, CloudStorage>
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.StoragesView";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Label lblHeader;
    private FooterComposite footerComposite;
    private Table table;
    private TableViewer tableViewer;

    public StoragesView() {
        LoginManager.login();
    }

    @Override
    protected void internalCreatePartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StoragesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(StoragesView.this.tableViewer, column.getProvider()));
                }
            });
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.update();
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = StoragesView.this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView");
                view.getSite().getPage().activate((IWorkbenchPart)view);
                view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
                StoragesView.this.getSite().getPage().activate((IWorkbenchPart)StoragesView.this);
            }
        });
    }

    @Override
    protected ICloudStorageManager getRootElement(IAccountResource.IRegion region) {
        return region.getCloudService(ICloudComputeService.class).getStorageManager();
    }

    @Override
    protected List<ICloudStorage> getElements(ICloudStorageManager root) {
        return Arrays.asList(root.getCloudStorages());
    }

    @Override
    protected PropertyId2<CollectionObserver2<ICloudStorage>> getPropertyId() {
        return ICloudStorageManager.p2.cloudStorages;
    }

    @Override
    protected boolean isMatchRegion(IAccountResource.IRegion region, ICloudStorage element) {
        return element.getCloudStorageManager().getRegion() == region;
    }

    @Override
    protected boolean isMatchAvailabilityZone(String zoneName, ICloudStorage element) {
        return zoneName.equals(element.getZone());
    }

    @Override
    protected boolean isMatchFacilityId(String facilityId, ICloudStorage element) {
        return facilityId.equals(element.getFacilityId());
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected List<CloudStorage> getManagerElements(CloudEndpoint endpoint, IAccountResource.IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
        IAccountResource accountResource = region.getAccountResource();
        ICloudUser cloudUser = null;
        cloudUser = accountResource.getActiveUser();
        String roleId = cloudUser.getRoleId();
        String regionId = region.getRegion();
        return endpoint.getStoragesByRegion(roleId, regionId);
    }

    @Override
    protected void setManagerElements(ICloudStorageManager rootElement, List<CloudStorage> managerElements) {
        ((CloudStorageManager)rootElement).internalUpdate(managerElements);
    }

    @Override
    protected boolean isInitialized(ICloudStorageManager rootElement) {
        return ((CloudStorageManager)rootElement).isInitialized();
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    static /* synthetic */ MessageManager access$100() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        storage_id(StoragesView.access$100().getString("word.storage_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getStorageId();
            }
        }),
        storage_name(StoragesView.access$100().getString("word.storage_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getStorageName();
            }
        }),
        cloud_type_id(StoragesView.access$100().getString("word.cloud_type_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getCloudTypeId();
            }
        }),
        state(StoragesView.access$100().getString("word.state"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getState();
            }
        }),
        attached_instance(StoragesView.access$100().getString("word.attached_instance"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                ICloudStorage storage = (ICloudStorage)element;
                if (storage != null && storage.getStorageAttachment() != null) {
                    return storage.getStorageAttachment().getInstanceId();
                }
                return "";
            }
        }),
        volume_type(StoragesView.access$100().getString("word.storage_type"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getFlavor();
            }
        }),
        facility_id(StoragesView.access$100().getString("word.facility_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getFacilityId();
            }
        }),
        facility_name(StoragesView.access$100().getString("word.facility_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getFacilityName();
            }
        }),
        size(StoragesView.access$100().getString("word.size"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudStorage)element).getSize() != null) {
                    return ((ICloudStorage)element).getSize().toString();
                }
                return null;
            }
        }),
        region(StoragesView.access$100().getString("word.region"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getCloudStorageManager().getRegion().getRegionName();
            }
        }),
        zone(StoragesView.access$100().getString("word.zone"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getZone();
            }
        }),
        regist_state(StoragesView.access$100().getString("word.regist_state"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getRegistState();
            }
        }),
        reg_user(StoragesView.access$100().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getRegUser();
            }
        }),
        reg_date(StoragesView.access$100().getString("word.reg_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudStorage)element).getRegDate() != null) {
                    return format.format(((ICloudStorage)element).getRegDate());
                }
                return "";
            }
        }),
        update_user(StoragesView.access$100().getString("word.update_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudStorage)element).getUpdateUser();
            }
        }),
        update_date(StoragesView.access$100().getString("word.update_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudStorage)element).getUpdateDate() != null) {
                    return format.format(((ICloudStorage)element).getUpdateDate());
                }
                return "";
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

