
package com.clustercontrol.ws.cloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>instanceRegistStateTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="instanceRegistStateType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="registered"/>
 *     &lt;enumeration value="unregistered"/>
 *     &lt;enumeration value="deleted"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "instanceRegistStateType")
@XmlEnum
public enum InstanceRegistStateType {

    @XmlEnumValue("registered")
    REGISTERED("registered"),
    @XmlEnumValue("unregistered")
    UNREGISTERED("unregistered"),
    @XmlEnumValue("deleted")
    DELETED("deleted");
    private final String value;

    InstanceRegistStateType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static InstanceRegistStateType fromValue(String v) {
        for (InstanceRegistStateType c: InstanceRegistStateType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
