/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.MessageManager;

public class CloudModelException extends RuntimeException {
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");

	private static final long serialVersionUID = -5229536826531257547L;

	private String errorCode = ErrorCodeConstants.UNEXPECTED;
	
	public CloudModelException() {
		super(bundle_messages.getString("message.unexpected_error"));
	}

	public CloudModelException(String message, Throwable cause) {
		super(message, cause);
	}

	public CloudModelException(String message) {
		super(message);
	}

	public CloudModelException(String message, String errorCode) {
		super(message);
		this.errorCode = errorCode;
	}

	public CloudModelException(Throwable cause) {
		super(bundle_messages.getString("message.unexpected_error"), cause);
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}

	@Override
	public String toString() {
		return super.toString() + " : ErrorCode=" + errorCode;
	}
}