/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.util.Messages;


public class DeleteStorageBackupAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DeleteImage";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strSnapshotId = messages.getString("word.snapshot_id");
	private String msgDeleteStorageBackupConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage_backup", "word.remove"});
	private String msgDeleteStorageBackupResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage_backup", "word.remove"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgDeleteStorageBackupConfirm + "\n" + strSnapshotId + " = " + backup.getStorageBackupId())
			){
			backup.getCloudStorageBackupManager().removeCloudStorageBackup(backup.getStorageBackupId());

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				msgDeleteStorageBackupResult);

		} else {
			return;
		}
	}
}