/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class CloudAccessorUtil {
    public static IResourceManagement getResourceManagement(String accountResourceId) throws CloudManagerFault {
        return (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)CloudAccessorUtil.getCloudTypeId(accountResourceId));
    }

    public static IUserManagement getUserManagement(String accountResourceId) throws CloudManagerFault {
        return (IUserManagement)ObjectRegistryService.registry().get(IUserManagement.class, (Object)CloudAccessorUtil.getCloudTypeId(accountResourceId));
    }

    public static IUserManagement.User getUser(String accountResourceId, String accessKey, String secretKey) throws CloudManagerFault {
        IUserManagement um = CloudAccessorUtil.getUserManagement(accountResourceId);
        um.setCredential(new IUserManagement.Credential(accessKey, secretKey));
        IUserManagement.User user = um.getCurrentUser();
        if (user == null) {
            throw ErrorCode.CLOUDUSER_INVALID_ACCESSKEY.cloudManagerFault(new Object[0]);
        }
        return user;
    }

    public static String getCloudTypeId(String accountResourceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("select s.cloudTypeId from CloudServiceDao s left join CloudAccountResourceDao r on (s.cloudServiceId = r.cloudServiceId) where r.accountResourceId = '" + accountResourceId + "'");
        try {
            return (String)query.getSingleResult();
        }
        catch (NoResultException e) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(accountResourceId);
        }
    }
}

