/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.commons.util.HinemosSessionContext;
import java.util.List;
import javax.persistence.Query;

public class AuthorizingUtil {
    public static boolean checkHinemousUser_administrators_account(String hinemousUserId, String accountResourceId) throws CloudManagerFault {
        if (!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty("isAdministrator"))) {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a WHERE u.userId = :userId AND a.accountResourceId = :accountResourceId AND c.cloudUserType = :cloudUserType");
            query.setParameter("userId", (Object)hinemousUserId);
            query.setParameter("accountResourceId", (Object)accountResourceId);
            query.setParameter("cloudUserType", (Object)CloudUserDao.CloudUserType.account);
            List daos = query.getResultList();
            return !daos.isEmpty();
        }
        return true;
    }

    public static boolean checkHinemousUser_administrators_account_self(String hinemousUserId, String cloudUserId) throws CloudManagerFault {
        if (!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty("isAdministrator"))) {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a WHERE u.userId = :userId AND (c.cloudUserId = :cloudUserId OR (a.accountResourceId = (SELECT a2.accountResourceId FROM CloudUserDao AS c2 JOIN c.accountResource a2 WHERE c2.cloudUserId = :cloudUserId) AND c.cloudUserType = :cloudUserType))");
            query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
            query.setParameter("cloudUserId", (Object)cloudUserId);
            query.setParameter("cloudUserType", (Object)CloudUserDao.CloudUserType.account);
            List daos = query.getResultList();
            return !daos.isEmpty();
        }
        return true;
    }
}

