/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.aws.util.AWSConstants;
import com.clustercontrol.cloud.aws.util.AWSUtil;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.util.CloudCredential;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

@Transactional(value=Transactional.TransactionType.Supported)
public class AWSOption
implements ICloudOption,
AWSConstants {
    public static final String targetsFilePath = "var/cloud/options/aws/billing_target.dat";
    private IResourceManagement.ICredential credential;

    public void setCredential(IResourceManagement.ICredential credential) {
        this.credential = credential;
    }

    public IResourceManagement.ICredential getCledential() {
        return this.credential;
    }

    public ICloudOption.Billing getBillingForCloudService(String target) throws CloudManagerFault {
        try {
            AmazonCloudWatch cloudWatch = AWSUtil.createCloudWatch((IResourceManagement.ICredential)new CloudCredential(this.credential.getAccessKey(), this.credential.getSecretKey()), null);
            GetMetricStatisticsRequest getMetricStatisticsRequest = new GetMetricStatisticsRequest();
            getMetricStatisticsRequest.withNamespace("AWS/Billing");
            getMetricStatisticsRequest.withMetricName("EstimatedCharges");
            GregorianCalendar start = new GregorianCalendar();
            start.set(6, start.get(6) - 1);
            getMetricStatisticsRequest.withStartTime(start.getTime());
            getMetricStatisticsRequest.withEndTime(new GregorianCalendar().getTime());
            getMetricStatisticsRequest.withPeriod(Integer.valueOf(3600));
            getMetricStatisticsRequest.withStatistics(new String[]{"Maximum"});
            if ("Total".equals(target) || target == null) {
                getMetricStatisticsRequest.withDimensions(new Dimension[]{new Dimension().withName("Currency").withValue("USD")});
            } else {
                getMetricStatisticsRequest.withDimensions(new Dimension[]{new Dimension().withName("ServiceName").withValue(target), new Dimension().withName("Currency").withValue("USD")});
            }
            GetMetricStatisticsResult resutlt = cloudWatch.getMetricStatistics(getMetricStatisticsRequest);
            Datapoint maxPoint = null;
            for (Datapoint dataPoint : resutlt.getDatapoints()) {
                if (maxPoint == null) {
                    maxPoint = dataPoint;
                    continue;
                }
                if (!maxPoint.getTimestamp().before(dataPoint.getTimestamp())) continue;
                maxPoint = dataPoint;
            }
            if (maxPoint != null) {
                ICloudOption.Billing billing = new ICloudOption.Billing();
                billing.setCurrency("USD");
                billing.setPrice(maxPoint.getMaximum().doubleValue());
                billing.setUpdateDate(maxPoint.getTimestamp());
                return billing;
            }
            return null;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getCloudServicesForBilling() throws CloudManagerFault {
        try {
            ArrayList<String> targets = new ArrayList<String>();
            String hinemosHome = System.getProperty("hinemos.manager.home.dir");
            try (BufferedReader reader = new BufferedReader(new FileReader(hinemosHome + "/" + targetsFilePath));){
                String target = reader.readLine();
                while (target != null) {
                    targets.add(target);
                    target = reader.readLine();
                }
            }
            targets.add(0, "Total");
            return targets;
        }
        catch (Exception e) {
            throw new InternalManagerError(e.getMessage(), (Throwable)e);
        }
    }
}

