/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.Transient;

import com.clustercontrol.cloud.dao.CloudEndpointDao;
import com.clustercontrol.cloud.dao.CloudRegionDao;

/**
 *
 */
public class CloudRegion implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6316558729382606000L;

	private Map<String, CloudEndpoint> endpoints = new HashMap<>();
	
	private CloudRegionDao dao;

	public CloudRegion() {
		dao = new CloudRegionDao();
	}
	
	public CloudRegion(CloudRegionDao dao) {
		this.dao = dao;
		for (CloudEndpointDao d: dao.getEndpoints()) {
			endpoints.put(d.getEndpointType(), new CloudEndpoint(d));
		}
	}
	
	/**
	 * @return
	 */
	public String getRegion() {
		return dao.getRegion();
	}

	/**
	 * @param region
	 */
	public void setRegion(String region) {
		dao.setRegion(region);
	}

	/**
	 * @return
	 */
	public String getCloudServiceId() {
		return dao.getCloudServiceId();
	}

	/**
	 * @param cloudServiceId
	 */
	public void setCloudServiceId(String cloudServiceId) {
		this.dao.setCloudServiceId(cloudServiceId);
	}

	/**
	 * @return
	 */
	public String getDescription() {
		return dao.getDescription();
	}

	/**
	 * @param description
	 */
	public void setDescription(String description) {
		this.dao.setDescription(description);
	}

	/**
	 * @return
	 */
	public String getRegionName() {
		return dao.getRegionName();
	}

	/**
	 * @param regionName
	 */
	public void setRegionName(String regionName) {
		this.dao.setRegionName(regionName);
	}
	
	@Transient
	public CloudEndpoint getEndpoint(String type) {
		return endpoints.get(type);
	}
}
