/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.dao.CloudUserDao.CloudUserType;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * クラウドユーザー情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addCloudUser(CreateCloudUserRequest) addCloudUser 関数}、
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#modifyCloudUser(ModifyCloudUserRequest) modifyCloudUser 関数} にて使用される。
 *
 */
public class CloudUser implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -9161813048730684001L;
	
	private CloudUserDao dao;
	private String accountResourceId;

	public CloudUser() {
		super();
		this.dao = new CloudUserDao();
	}

	public CloudUser(CloudUserDao dao) {
		super();
		this.dao = new CloudUserDao(dao);
		this.accountResourceId = dao.getAccountResource().getAccountResourceId();
	}
	/**
	 * クラウドユーザー Id を取得する。
	 * 
	 * @return クラウドユーザー Id
	 */
	@Identity
	public String getCloudUserId() {
		return dao.getCloudUserId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param cloudUserId
	 */
	public void setCloudUserId(String cloudUserId) {
		throw new UnsupportedOperationException();
	}
	/**
	 * クラウドユーザー名を取得します。
	 * 
	 * @return クラウドユーザー名。
	 */
	@Size(max=128)
	@NotNull(groups=ValidationConstants.group_creation)
	public String getCloudUserName() {
		return dao.getCloudUserName();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param cloudUserName
	 */
	public void setCloudUserName(String cloudUserName) {
		throw new UnsupportedOperationException();
	}
	/**
	 * AWS アカウントあるいは、IAM ユーザーのシークレットキーを取得します。
	 * 
	 * @return　シークレットキー。
	 */
	@NotNull(groups=ValidationConstants.group_creation)
	public String getSecretKey() {
		return dao.getSecretKey();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param secretKey
	 */
	public void setSecretKey(String secretKey) {
		throw new UnsupportedOperationException();
	}
	/**
	 * AWS アカウントあるいは、IAM ユーザーのアクセスキーを取得します。
	 * 
	 * @return　アクセスキー。
	 */
	@NotNull(groups=ValidationConstants.group_creation)
	public String getAccessKey() {
		return dao.getAccessKey();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param accessKey
	 */
	public void setAccessKey(String accessKey) {
		throw new UnsupportedOperationException();
	}

	/**
	 * クラウド Id を取得します。現在は、"AWS" のみです。
	 * 
	 * @return クラウド Id
	 */
	@Identity(groups=ValidationConstants.group_creation)
	public String getAccountResourceId() {
		return accountResourceId;
	}

	/**
	 * 使用禁止。
	 * 
	 * @param accountResourceId
	 */
	public void setAccountResourceId(String accountResourceId) {
		throw new UnsupportedOperationException();
	}
	/**
	 * 説明を取得します。
	 * 
	 * @return　説明。
	 */
	public String getDescription() {
		return dao.getDescription();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param description
	 */
	public void setDescription(String description) {
		throw new UnsupportedOperationException();
	}
	/**
	 * クラウドユーザー種別を取得します。
	 * 
	 * @return クラウドユーザー種別。
	 */
	@NotNull(groups=ValidationConstants.group_creation)
	public CloudUserType getCloudUserType() {
		if (dao.getCloudUserType() != null) {
			return CloudUserType.valueOf(dao.getCloudUserType().name());
		}
		return null;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param cloudUserType
	 */
	public void setCloudUserType(CloudUserType cloudUserType) {
		throw new UnsupportedOperationException();
	}
	/**
	 * クラウドユーザーに紐づく Hinemos ユーザーを取得します。
	 * 
	 * @return Hinemos ユーザー。
	 */
	@Identity(groups=ValidationConstants.group_creation)
	public String getRoleId() {
		return dao.getRoleId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param userId
	 */
	public void setRoleId(String roleId) {
		throw new UnsupportedOperationException();
	}
	/**
	 * 登録日を取得します。
	 * 
	 * @return 登録日。
	 */
	@ReadOnly
	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}

	/**
	 * 使用禁止。
	 * 
	 * @param regDate
	 */
	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	/**
	 * 更新日を取得します。
	 * 
	 * @return 更新日。
	 */
	@ReadOnly
	public Long getUpdateDate() {
		return dao.getUpdateDate() != null ? dao.getUpdateDate().getTime(): null;

	}

	/**
	 * 使用禁止。
	 * 
	 * @param updateDate
	 */
	public void setUpdateDate(Long updateDate) {
		throw new UnsupportedOperationException();
	}
	/**
	 * 登録ユーザーを取得します。
	 * 
	 * @return 登録ユーザー。
	 */
	@ReadOnly
	public String getRegUser() {
		return dao.getRegUser();
	}

	/**
	 * 使用禁止。
	 * 
	 * @param regUser
	 */
	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}

	/**
	 * 更新ユーザーを取得します。
	 * 
	 * @return 更新ユーザー。
	 */
	@ReadOnly
	public String getUpdateUser() {
		return dao.getUpdateUser();
	}

	/**
	 * 使用禁止。
	 * 
	 * @param updateUser
	 */
	public void setUpdateUser(String updateUser) {
		throw new UnsupportedOperationException();
	}

	@XmlTransient
	public CloudUserDao getTableData() {
		return dao;
	}
}