/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;

public interface ITemplateOperator extends IResourceOperatorBase {

	CloudTemplate createTemplate(CreateTemplateRequest request) throws CloudManagerFault;
	
	CloudTemplate modifyTemplate(ModifyTemplateRequest request) throws CloudManagerFault;
	
	void removeTemplate(String templateId) throws CloudManagerFault;

	CloudTemplate findTemplate(String templateId) throws CloudManagerFault;

	List<CloudTemplate> findAllTemplates() throws CloudManagerFault;

	List<String> findTemplateScripts() throws CloudManagerFault;
}
