/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.presenter;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.util.LoginManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.soap.SOAPBinding;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class EndpointHolder<T>
extends ThreadLocal<T> {
    @Override
    protected T initialValue() {
        InvocationHandler h = new InvocationHandler(){
            private String currentUserId;
            private String currentPassword;
            private String currentUrl;
            private T endpoint;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String userId;
                if (this.endpoint == null) {
                    userId = LoginManager.getUserId();
                    String password = LoginManager.getPassword();
                    String url = LoginManager.getUrl();
                    this.endpoint = EndpointHolder.this.createEndpoint(userId, password, url);
                    this.currentUserId = userId;
                    this.currentPassword = password;
                    this.currentUrl = url;
                } else {
                    userId = LoginManager.getUserId();
                    String password = LoginManager.getPassword();
                    String url = LoginManager.getUrl();
                    if (userId == null || password == null || url == null) {
                        throw new IllegalStateException();
                    }
                    if (!(userId.equals(this.currentUserId) && password.equals(this.currentPassword) && url.equals(this.currentUrl))) {
                        this.endpoint = EndpointHolder.this.createEndpoint(userId, password, url);
                        this.currentUserId = userId;
                        this.currentPassword = password;
                        this.currentUrl = url;
                    }
                }
                try {
                    return method.invoke(this.endpoint, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        };
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getEndpointClass()}, h);
    }

    protected T createEndpoint(String userId, String password, String url) {
        T endpoint = null;
        try {
            String urlEndpoint = LoginManager.getUrl() + this.getEndpointServiceClass().getSimpleName();
            endpoint = this.createEndpoint(urlEndpoint);
            BindingProvider bp = (BindingProvider)endpoint;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlEndpoint);
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", userId);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
            IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
            int httpConnectTimeout = store.getInt("httpConnectTimeout");
            int httpRequestTimeout = store.getInt("httpRequestTimeout");
            bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", httpConnectTimeout * 1000);
            bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", httpRequestTimeout * 1000);
            ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return endpoint;
    }

    protected abstract Class<T> getEndpointClass();

    protected abstract Class<?> getEndpointServiceClass();

    protected abstract String getNamespace();

    protected T createEndpoint(String urlEndpoint) throws Exception {
        Object service = this.getEndpointServiceClass().getConstructor(URL.class, QName.class).newInstance(new URL(urlEndpoint + "?wsdl"), new QName(this.getNamespace(), this.getEndpointServiceClass().getSimpleName()));
        for (Method method : service.getClass().getDeclaredMethods()) {
            if (method.getAnnotation(WebEndpoint.class) == null || method.getParameterTypes().length != 0 || method.getReturnType() != this.getEndpointClass()) continue;
            return (T)method.invoke(service, new Object[0]);
        }
        throw new NoSuchMethodException();
    }
}

