/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.AttachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AttachStorageFromInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgAttachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
    private String msgAttachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        AttachStorageFromInstanceDialog dialog = new AttachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgAttachStorageConfirm + "\n" + dialog.getStorageId()))) {
                instance.attachStorage(dialog.getStorageId(), "dummy");
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgAttachStorageResult);
                JobTrackingService.trackAttachStorage(this.viewPart, instance, dialog.getStorageId());
            } else {
                return;
            }
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name());
    }
}

