/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.action;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.plugin.action.IActionPluginManager;
import com.clustercontrol.cloud.plugin.action.IActionPluginProvider;
import com.clustercontrol.cloud.presenter.CloudModelException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ActionPluginManager
implements IActionPluginManager {
    Map<String, IActionPluginProvider> providers = null;

    private void init() {
        this.providers = new HashMap<String, IActionPluginProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + ".actionPlugin");
        for (IExtension extension : point.getExtensions()) {
            for (IConfigurationElement element : extension.getConfigurationElements()) {
                IActionPluginProvider pluginProvider = null;
                if (element.getName().equals("action_plugin")) {
                    try {
                        pluginProvider = (IActionPluginProvider)element.createExecutableExtension("plugin_action_provider_class");
                    }
                    catch (CoreException e) {
                        throw new CloudModelException(e);
                    }
                }
                if (pluginProvider == null) continue;
                assert (pluginProvider.getCloudTypeId() != null) : "CloudTypeId is null.";
                assert (!pluginProvider.getCloudTypeId().isEmpty()) : "CloudTypeId is empty.";
                this.providers.put(pluginProvider.getCloudTypeId(), pluginProvider);
            }
        }
    }

    @Override
    public IActionPluginProvider getActionPluginProvider(String cloudTypeId) {
        this.checkInit();
        return this.providers.get(cloudTypeId);
    }

    @Override
    public Boolean isPlugined(String cloudTypeId) {
        this.checkInit();
        return this.providers.containsKey(cloudTypeId);
    }

    private void checkInit() {
        if (this.providers == null) {
            this.init();
        }
    }
}

