/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.monitor;

import com.clustercontrol.cloud.plugin.monitor.FacilityTreeComposite;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.FacilityTreeItemUtil;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;

public class FacilityTree {
    Logger logger = Logger.getLogger(this.getClass());
    private static FacilityTreeItem m_facilityTreeCache = null;
    private static final Set<Composite> m_DisplayViewSet = new HashSet<Composite>();

    public FacilityTreeItem getTreeItem() {
        FacilityTreeItem item = null;
        if (m_facilityTreeCache == null) {
            this.refreshCache();
        }
        item = FacilityTreeItemUtil.deepCopy((FacilityTreeItem)m_facilityTreeCache, null);
        return item;
    }

    public String getSeparator() {
        String separator = ">";
        return separator;
    }

    public static void clearCache() {
        m_facilityTreeCache = null;
    }

    public void refresh() {
        this.logger.trace((Object)"FacilityTree.refresh() start");
        this.refreshCache();
        this.refreshComposite();
        this.logger.trace((Object)"FacilityTree.refresh() stop");
    }

    private void refreshCache() {
        FacilityTreeItem item = null;
        try {
            item = RepositoryEndpointWrapper.getFacilityTree(null);
            if (item != null) {
                m_facilityTreeCache = item;
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("getFacilityTree(), " + e.getMessage()), (Throwable)e);
            return;
        }
        this.logger.trace((Object)"FacilityTree.refreshCache() : stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshComposite() {
        this.logger.trace((Object)"FacilityTree.refreshComposite() : start");
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            for (FacilityTreeComposite facilityTreeComposite : m_DisplayViewSet) {
                if (facilityTreeComposite.isDisposed()) continue;
                this.logger.trace((Object)("FacilityTree.refreshComposite() : target is " + ((Object)((Object)facilityTreeComposite)).getClass().getCanonicalName()));
                facilityTreeComposite.update();
            }
        }
        this.logger.trace((Object)"refreshComposite() : stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComposite(FacilityTreeComposite composite) {
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            m_DisplayViewSet.add(composite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delComposite(FacilityTreeComposite composite) {
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            m_DisplayViewSet.remove((Object)composite);
        }
    }
}

