/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.AccountResourceManager;
import com.clustercontrol.cloud.presenter.CloudComputeService;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudTemplateManager;
import com.clustercontrol.cloud.presenter.CloudUserManager;
import com.clustercontrol.cloud.presenter.EditBillingDetailCollectorSettingRequet;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.presenter.ModifyAccountResourceRequest;
import com.clustercontrol.ws.cloud.CloudAccountResource;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudRegion;
import com.clustercontrol.ws.cloud.ModifyAccountBillingDetailRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountResource
extends InternalComponent<AccountResourceManager, CloudAccountResource>
implements IAccountResource {
    private Map<Class<?>, Object> pluginServicesMap = new HashMap();
    private CloudUserManager cloudUserManager;
    private Region[] regions;
    private String accountId;
    private String accountResourceId;
    private String accountResourceName;
    private String cloudServiceId;
    private String description;
    private Boolean billingDetailCollectorFlg;
    private Integer retentionPeriod;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;
    private ICloudUser activeCloudUser;
    private CloudTemplateManager cloudTemplateManager;

    @Override
    public <T> T getCloudService(Class<T> serviceClass) {
        if (this.pluginServicesMap != null) {
            return (T)this.pluginServicesMap.get(serviceClass);
        }
        return null;
    }

    public static AccountResource createAccountResource(AccountResourceManager accountResourceManager, CloudAccountResource source) {
        AccountResource accountResource = new AccountResource(accountResourceManager);
        accountResource.overwrite(source);
        return accountResource;
    }

    public AccountResource(AccountResourceManager accountResourceManager) {
        super(accountResourceManager);
    }

    @Override
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    @Override
    public String getAccountResourceName() {
        return this.accountResourceName;
    }

    @Override
    public String getCloudServiceId() {
        return this.cloudServiceId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean getBillingDetailCollectorFlg() {
        return this.billingDetailCollectorFlg;
    }

    @Override
    public void setActiveUser(ICloudUser activeCloudUser) {
        this.activeCloudUser = activeCloudUser;
    }

    @Override
    public ICloudUser getActiveUser() {
        return this.activeCloudUser;
    }

    @Override
    public Long getRegDate() {
        return this.regDate;
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    @Override
    public Long getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Override
    public AccountResourceManager getAccountResourceManager() {
        return (AccountResourceManager)this.getContainer();
    }

    @Override
    public CloudUserManager getCloudUserManager() {
        if (this.cloudUserManager == null) {
            this.cloudUserManager = new CloudUserManager(this);
        }
        return this.cloudUserManager;
    }

    @Override
    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @Import
    public void setAccountResourceId(String accountResourceId) {
        this.internalSet("accountResourceId", IAccountResource.p2.accountResourceId, accountResourceId);
    }

    @Import
    public void setAccountResourceName(String accountResourceName) {
        this.internalSet("accountResourceName", IAccountResource.p2.accountResourceName, accountResourceName);
    }

    @Import
    public void setCloudServiceId(String cloudServiceId) {
        this.internalSet("cloudServiceId", IAccountResource.p2.cloudServiceId, cloudServiceId);
    }

    @Import
    public void setDescription(String description) {
        this.internalSet("description", IAccountResource.p2.description, description);
    }

    @Import
    public void setBillingDetailCollectorFlg(Boolean billingDetailCollectorFlg) {
        this.internalSet("billingDetailCollectorFlg", IAccountResource.p2.billingDetailCollectorFlg, billingDetailCollectorFlg);
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", IAccountResource.p2.regDate, regDate);
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", IAccountResource.p2.regUser, regUser);
    }

    @Import
    public void setUpdateDate(Long updateDate) {
        this.internalSet("updateDate", IAccountResource.p2.updateDate, updateDate);
    }

    @Import
    public void setUpdateUser(String updateUser) {
        this.internalSet("updateUser", IAccountResource.p2.updateUser, updateUser);
    }

    @Import
    public void setRetentionPeriod(Integer retentionPeriod) {
        this.internalSet("retentionPeriod", IAccountResource.p2.retentionPeriod, retentionPeriod);
    }

    public Region[] getRegions() {
        if (this.regions == null) {
            try {
                List cloudRegions = this.getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).getCloudRegionsByService(this.getCloudServiceId());
                Region[] rs = new Region[cloudRegions.size()];
                for (int i = 0; i < cloudRegions.size(); ++i) {
                    rs[i] = new Region(this, (CloudRegion)cloudRegions.get(i));
                }
                this.regions = rs;
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        return this.regions;
    }

    @Override
    public CloudAccountResource getSource() throws CloudModelException {
        return null;
    }

    @Override
    public void overwrite(CloudAccountResource source) {
        ControlUtil.importObject(this, source);
        this.setBillingDetailCollectorFlg(source.isBillingDetailCollectorFlg());
    }

    @Override
    public boolean equalValues(CloudAccountResource source) {
        assert (source != null);
        return this.getAccountResourceId().equals(source.getAccountResourceId());
    }

    @Override
    public AccountResource modifyAccountResource(ModifyAccountResourceRequest modifyAccountResourceRequest) {
        com.clustercontrol.ws.cloud.ModifyAccountResourceRequest wsModifyAccountResourceRequest = new com.clustercontrol.ws.cloud.ModifyAccountResourceRequest();
        ControlUtil.exportObject(modifyAccountResourceRequest, wsModifyAccountResourceRequest);
        try {
            CloudAccountResource reWsAccountResource = this.getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).modifyAccountResource(wsModifyAccountResourceRequest);
            this.overwrite(reWsAccountResource);
            return this;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void editBillingDetailCollectorSetting(EditBillingDetailCollectorSettingRequet request) {
        ModifyAccountBillingDetailRequest wsRequest = new ModifyAccountBillingDetailRequest();
        ControlUtil.exportObject(request, wsRequest);
        try {
            this.overwrite(this.getEndpoint().modifyAccountBillingDetail(wsRequest));
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Import
    public void setAccountId(String accountId) {
        this.internalSet("accountId", IAccountResource.p2.accountId, accountId);
    }

    public CloudEndpoint getEndpoint() {
        return this.getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    @Override
    public Region getRegion(String region) {
        for (Region r : this.getRegions()) {
            if (!r.getRegion().equals(region)) continue;
            return r;
        }
        return null;
    }

    @Override
    public CloudTemplateManager getCloudTemplateManager() {
        if (this.cloudTemplateManager == null) {
            this.cloudTemplateManager = new CloudTemplateManager(this);
        }
        return this.cloudTemplateManager;
    }

    @Override
    public <T> void putService(Class<T> interfaceClass, T instance) {
        this.pluginServicesMap.put(interfaceClass, instance);
    }

    public static class Region
    implements IAccountResource.IRegion {
        private AccountResource accountResource;
        private String region;
        private String regionName;
        private CloudComputeService cloudComputeService;
        private Map<Class<?>, Object> pluginServicesMap = new HashMap();

        public Region(AccountResource accountResource, CloudRegion region) {
            this.accountResource = accountResource;
            this.region = region.getRegion();
            this.regionName = region.getRegionName();
        }

        @Override
        public AccountResource getAccountResource() {
            return this.accountResource;
        }

        @Override
        public String getRegion() {
            return this.region;
        }

        @Override
        public String getRegionName() {
            return this.regionName;
        }

        @Override
        public <T> T getCloudService(Class<T> serviceClass) {
            if (serviceClass.isAssignableFrom(ICloudComputeService.class)) {
                if (this.cloudComputeService == null) {
                    this.cloudComputeService = new CloudComputeService(this);
                }
                return (T)this.cloudComputeService;
            }
            if (this.pluginServicesMap != null) {
                return (T)this.pluginServicesMap.get(serviceClass);
            }
            return null;
        }

        public CloudEndpoint getEndpoint() {
            return this.getAccountResource().getEndpoint();
        }

        @Override
        public <T> void putService(Class<T> interfaceClass, T instance) {
            this.pluginServicesMap.put(interfaceClass, instance);
        }
    }
}

