/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.plugin.decorator.IAccountResourceDecorator;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.CreateAccountResourceRequest;
import com.clustercontrol.cloud.presenter.CreateCloudUserRequest;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.ws.cloud.Account;
import com.clustercontrol.ws.cloud.CloudAccountResource;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import java.util.List;

public class AccountResourceManager
extends InternalContainer<AccountResource, CloudAccountResource>
implements IAccountResourceManager {
    private CloudResourceManager resourceManager;

    public AccountResourceManager(CloudResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public AccountResource[] getAccountResources() {
        return this.getComponents().toArray(new AccountResource[this.getComponents().size()]);
    }

    @Override
    public AccountResource getAccountResource(String accountResourceId) {
        for (AccountResource accountResource : this.getComponents()) {
            if (!accountResource.getAccountResourceId().equals(accountResourceId)) continue;
            return accountResource;
        }
        return null;
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.resourceManager;
    }

    @Override
    public List<CloudAccountResource> getSources() throws CloudModelException {
        try {
            return this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).getAllAccountResources();
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public AccountResource createComponent(CloudAccountResource source) throws CloudModelException {
        AccountResource accountResource = AccountResource.createAccountResource(this, source);
        if (accountResource != null) {
            for (IAccountResourceDecorator decorator : this.getCloudResourceManager().getARDecoratorProvider().getDecoratorList()) {
                decorator.decorate(accountResource);
            }
        }
        return accountResource;
    }

    @Override
    public AccountResource createAccountResource(CreateAccountResourceRequest createAccountResourceRequest, CreateCloudUserRequest createCloudUserRequest) {
        com.clustercontrol.ws.cloud.CreateAccountResourceRequest wsCreateAccountResourceRequest = new com.clustercontrol.ws.cloud.CreateAccountResourceRequest();
        ControlUtil.exportObject(createAccountResourceRequest, wsCreateAccountResourceRequest);
        Account account = new Account();
        ControlUtil.exportObject(createCloudUserRequest, account);
        wsCreateAccountResourceRequest.setAccount(account);
        try {
            CloudAccountResource reWsAccountResource = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).addAccountResource(wsCreateAccountResourceRequest);
            AccountResource accountResource = this.createComponent(reWsAccountResource);
            this.getComponents().add(accountResource);
            this.fireElementAdded(IAccountResourceManager.p2.accountResources, accountResource);
            return accountResource;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeAccountResource(String accountResourceId) {
        try {
            this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).removeAccountResource(accountResourceId);
            AccountResource accountResource = this.getAccountResource(accountResourceId);
            this.getComponents().remove(accountResource);
            this.fireElementRemoved(IAccountResourceManager.p2.accountResources, accountResource);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void fireComponentAdded(AccountResource addedValue) {
        this.fireElementAdded(IAccountResourceManager.p2.accountResources, addedValue);
    }

    @Override
    protected void fireComponentRemoved(AccountResource removedValue) {
        this.fireElementAdded(IAccountResourceManager.p2.accountResources, removedValue);
    }
}

