/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudTemplateManager;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.presenter.ModifyCloudTemplateRequest;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ModifyTemplateRequest;

public class CloudTemplate
extends InternalComponent<CloudTemplateManager, com.clustercontrol.ws.cloud.CloudTemplate>
implements ICloudTemplate {
    private String accountResourceId;
    private String cloudTypeId;
    private String cloudUserId;
    private String templateId;
    private String templateName;
    private String imageId;
    private String region;
    private String jobUnitId;
    private String launchJobId;
    private String startJobId;
    private String stopJobId;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;

    public CloudTemplate(CloudTemplateManager container) {
        super(container);
    }

    @Override
    @Export
    public String getTemplateId() {
        return this.templateId;
    }

    @Import
    public void setTemplateId(String templateId) {
        this.internalSet("templateId", ICloudTemplate.p2.templateId, templateId);
    }

    @Override
    @Export
    public String getTemplateName() {
        return this.templateName;
    }

    @Import
    public void setTemplateName(String templateName) {
        this.internalSet("templateName", ICloudTemplate.p2.templateName, templateName);
    }

    @Override
    @Export
    public String getImageId() {
        return this.imageId;
    }

    @Import
    public void setImageId(String imageId) {
        this.internalSet("imageId", ICloudTemplate.p2.imageId, imageId);
    }

    @Override
    @Export
    public String getLaunchJobId() {
        return this.launchJobId;
    }

    @Import
    public void setLaunchJobId(String launchJobId) {
        this.internalSet("launchJobId", ICloudTemplate.p2.launchJobId, launchJobId);
    }

    @Override
    @Export
    public String getRegion() {
        return this.region;
    }

    @Import
    public void setRegion(String region) {
        this.internalSet("region", ICloudTemplate.p2.region, region);
    }

    @Override
    @Export
    public Long getRegDate() {
        return this.regDate;
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudTemplate.p2.regDate, regDate);
    }

    @Override
    @Export
    public String getRegUser() {
        return this.regUser;
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudTemplate.p2.regUser, regUser);
    }

    @Override
    @Export
    public Long getUpdateDate() {
        return this.updateDate;
    }

    @Import
    public void setUpdateDate(Long updateDate) {
        this.internalSet("updateDate", ICloudTemplate.p2.updateDate, updateDate);
    }

    @Override
    @Export
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Import
    public void setUpdateUser(String updateUser) {
        this.internalSet("updateUser", ICloudTemplate.p2.updateUser, updateUser);
    }

    @Override
    @Export
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    @Import
    public void setCloudUserId(String cloudUserId) {
        this.internalSet("cloudUserId", ICloudTemplate.p2.cloudUserId, cloudUserId);
    }

    @Override
    @Export
    public String getStartJobId() {
        return this.startJobId;
    }

    @Import
    public void setStartJobId(String startJobId) {
        this.internalSet("startJobId", ICloudTemplate.p2.startJobId, startJobId);
    }

    @Override
    @Export
    public String getStopJobId() {
        return this.stopJobId;
    }

    @Import
    public void setStopJobId(String stopJobId) {
        this.internalSet("stopJobId", ICloudTemplate.p2.stopJobId, stopJobId);
    }

    @Override
    @Export
    public String getJobUnitId() {
        return this.jobUnitId;
    }

    @Import
    public void setJobUnitId(String jobUnitId) {
        this.internalSet("jobUnitId", ICloudTemplate.p2.jobUnitId, jobUnitId);
    }

    @Override
    @Export
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    @Import
    public void setAccountResourceId(String accountResourceId) {
        this.internalSet("accountResourceId", ICloudTemplate.p2.accountResourceId, accountResourceId);
    }

    @Override
    @Export
    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    @Import
    public void setCloudTypeId(String cloudTypeId) {
        this.internalSet("cloudTypeId", ICloudTemplate.p2.cloudTypeId, cloudTypeId);
    }

    @Override
    public CloudTemplateManager getCloudTemplateManager() {
        return (CloudTemplateManager)this.getContainer();
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudTemplate source) {
        return this.getTemplateId().equals(source.getTemplateId());
    }

    public static CloudTemplate createCloudTemplate(CloudTemplateManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudTemplate source) {
        CloudTemplate cloudInstance = new CloudTemplate(cloudInstanceManager);
        cloudInstance.overwrite(source);
        return cloudInstance;
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudTemplate getSource() throws CloudModelException {
        try {
            return this.getEndpoint().getTemplate(this.getRoleId(), this.getTemplateId());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudTemplate source) {
        ControlUtil.importObject(this, source);
        this.setCloudTypeId(this.internalGetCloudTypeId());
    }

    private CloudEndpoint getEndpoint() {
        return this.getCloudTemplateManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String internalGetCloudTypeId() {
        String cloudServiceId = this.getCloudTemplateManager().getAccountResource().getCloudServiceId();
        String cloudTypeId = this.getCloudTemplateManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
        return cloudTypeId;
    }

    private String getRoleId() {
        return this.getCloudTemplateManager().getAccountResource().getActiveUser().getRoleId();
    }

    @Override
    public void modifyCloudTemplate(ModifyCloudTemplateRequest modifyCloudTemplateRequest) {
        ModifyTemplateRequest wsRequest = new ModifyTemplateRequest();
        ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();
        ControlUtil.importObject(request, modifyCloudTemplateRequest);
        ControlUtil.exportObject(request, wsRequest);
        try {
            com.clustercontrol.ws.cloud.CloudTemplate modifiedTemplate = this.getEndpoint().modifyTemplate(this.getRoleId(), wsRequest);
            this.overwrite(modifiedTemplate);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }
}

