/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudService;
import com.clustercontrol.cloud.presenter.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.ui.dialogs.EditAccountResourceDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class EditAccountResourceAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditAccountResourceAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgEditAccountResourceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.account_resource", "word.modify"});
    private String msgEditAccountResourceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.account_resource", "word.modify"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IStructuredSelection selection = (IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection();
        final IAccountResource accountResource = (IAccountResource)selection.getFirstElement();
        EditAccountResourceDialog dialog = new EditAccountResourceDialog(this.viewPart.getSite().getShell());
        dialog.setBehavior(new EditAccountResourceDialog.DialogBehavior(){

            @Override
            public void setupAccountResourceId(Text txtAccountResourceId) {
                if (accountResource != null && accountResource.getAccountResourceId() != null) {
                    txtAccountResourceId.setText(accountResource.getAccountResourceId());
                }
                txtAccountResourceId.setEditable(false);
            }

            @Override
            public void setupAccountResourceName(Text accountResourceName) {
                if (accountResource != null && accountResource.getAccountResourceName() != null) {
                    accountResourceName.setText(accountResource.getAccountResourceName());
                }
            }

            @Override
            public void setupAccountResourceDescription(Text txtAccountResourceDescription) {
                if (accountResource != null && accountResource.getDescription() != null) {
                    txtAccountResourceDescription.setText(accountResource.getDescription());
                }
            }

            @Override
            public void setupCloudServiceId(Combo cmbCloudServiceId) {
                super.setupCloudServiceId(cmbCloudServiceId);
                ICloudService service = accountResource.getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(accountResource.getCloudServiceId());
                if (cmbCloudServiceId.indexOf(service.getCloudServiceName()) != -1) {
                    cmbCloudServiceId.select(cmbCloudServiceId.indexOf(service.getCloudServiceName()));
                }
                cmbCloudServiceId.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgEditAccountResourceConfirm)) {
                EditAccountResourceDialog.DialogOutput output = dialog.getOutput();
                ModifyAccountResourceRequest request = new ModifyAccountResourceRequest();
                ControlUtil.importObject(request, accountResource);
                ControlUtil.importObject(request, output);
                request.setDescription(output.getAccountResourceDescription());
                accountResource.modifyAccountResource(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgEditAccountResourceResult);
            } else {
                return;
            }
        }
    }
}

