/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorage extends InternalComponent<CloudStorageManager, com.clustercontrol.ws.cloud.CloudStorage> implements ICloudStorage {
    private String storageId;
    private String storageName;
    private String facilityId;
    private String facilityName;
    private String cloudTypeId;
    //status
    private String state;
    //attachedInstance
    private StorageAttachment storageAttachment;
    //volumeType
    private String flavor;
    private Integer size;
    private String region;
    private String zone;
    private String registState;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;
    
    private Integer deviceIndex;
    private String deviceName;
    private String deviceType;
    private String snapshotId;
    
	public CloudStorage(CloudStorageManager container) {
		super(container);
	}
	
	@Override
	@Export
	public String getStorageId() {
		return storageId;
	}
	
	@Import
	public void setStorageId(String storageId) {
		internalSet("storageId", p2.storageId, storageId);
	}

	@Override
	@Export
	public String getStorageName() {
		return storageName;
	}
	
	@Import
	public void setStorageName(String storageName) {
		internalSet("storageName", p2.storageName, storageName);
	}

	@Override
	@Export
	public String getFacilityId() {
		return facilityId;
	}
	
	@Import
	public void setFacilityId(String facilityId) {
		internalSet("facilityId", p2.facilityId, facilityId);
	}

	@Override
	@Export
	public String getFacilityName() {
		return facilityName;
	}
	
	@Import
	public void setFacilityName(String facilityName) {
		internalSet("facilityName", p2.facilityName, facilityName);
	}

	@Override
	@Export
	public String getCloudTypeId() {
		return cloudTypeId;
	}
	
	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}

	@Override
	@Export
	public String getFlavor() {
		return flavor;
	}
	
	@Import
	public void setFlavor(String flavor) {
		internalSet("flavor", p2.flavor, flavor);
	}

	@Override
	@Export
	public String getRegion() {
		return region;
	}
	
	@Import
	public void setRegion(String region) {
		internalSet("region", p2.region, region);
	}
	
	@Override
	@Export
	public String getZone() {
		return zone;
	}
	
	@Import
	public void setZone(String zone) {
		internalSet("zone", p2.zone, zone);
	}
	
	@Override
	@Export
	public String getState() {
		return state;
	}
	
	@Import
	public void setState(String state) {
		internalSet("state", p2.state, state);
	}

	@Override
	@Export
	public Integer getSize() {
		return size;
	}
	
	@Import
	public void setSize(Integer size) {
		internalSet("size", p2.size, size);
	}

	@Override
	@Export
	public String getRegistState() {
		return registState;
	}
	
	@Import
	public void setRegistState(String registState) {
		internalSet("registState", p2.registState, registState);
	}

	@Override
	@Export
	public StorageAttachment getStorageAttachment() {
		return storageAttachment;
	}
	
	@Import
	public void setStorageAttachment(StorageAttachment storageAttachment) {
		internalSet("storageAttachment", p2.storageAttachment, storageAttachment);
	}

	@Override
	@Export
	public String getSnapshotId() {
		return snapshotId;
	}
	
	@Import
	public void setSnapshotId(String snapshotId) {
		internalSet("snapshotId", p2.snapshotId, snapshotId);
	}

	@Override
	@Export
	public Integer getDeviceIndex() {
		return deviceIndex;
	}
	
	@Import
	public void setDeviceIndex(Integer deviceIndex) {
		internalSet("deviceIndex", p2.deviceIndex, deviceIndex);
	}

	@Override
	@Export
	public String getDeviceType() {
		return deviceType;
	}
	
	@Import
	public void setDeviceType(String deviceType) {
		internalSet("deviceType", p2.deviceType, deviceType);
	}

	@Override
	@Export
	public String getDeviceName() {
		return deviceName;
	}
	
	@Import
	public void setDeviceName(String deviceName) {
		internalSet("deviceName", p2.deviceName, deviceName);
	}

	@Override
	@Export
	public Long getRegDate() {
		return regDate;
	}
	
	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	
	@Override
	@Export
	public String getRegUser() {
		return regUser;
	}
	
	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}
	
	@Override
	@Export
	public Long getUpdateDate() {
		return updateDate;
	}
	
	@Import
	public void setUpdateDate(Long updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}
	
	@Override
	@Export
	public String getUpdateUser() {
		return updateUser;
	}
	
	@Import
	public void setUpdateUser(String updateUser) {
		internalSet("updateUser", p2.updateUser, updateUser);
	}
	
	@Override
	public CloudStorageManager getCloudStorageManager() {
		return getContainer();
	}

	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudStorage source) {
		return getStorageId().equals(source.getStorageId());
	}

	public static CloudStorage createCloudStorage(CloudStorageManager cloudStorageManager, com.clustercontrol.ws.cloud.CloudStorage source) {
		CloudStorage cloudStorage = new CloudStorage(cloudStorageManager);
		cloudStorage.overwrite(source);
		return cloudStorage;
	}
	
	@Override
	public com.clustercontrol.ws.cloud.CloudStorage getSource() throws CloudModelException {
		try {
			return getEndpoint().getStorage(getRoleId(), getCloudStorageManager().getRegion().getRegion(), getStorageId());
		}
		catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudStorage source) {
		ControlUtil.importObject(this, source);
//		if(source.getRegistState() != null){
			setRegistState(source.getRegistState().value());
//		}
		if(source.getStorageAttachment() != null){
			StorageAttachment storageAttachment = new StorageAttachment();
			ControlUtil.importObject(storageAttachment, source.getStorageAttachment());
			setStorageAttachment(storageAttachment);
		}
		setCloudTypeId(internalGetCloudTypeId());
	}

	@Override
	public void attach(String instanceId, String deviceName) {
		try {
			getEndpoint().attachStorage(getRoleId(), getRegion(), instanceId, getStorageId(), deviceName);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void detach() {
		try {
			getEndpoint().detachStorage(getRoleId(), getRegion(), getStorageAttachment().getInstanceId(), getStorageId());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	private String getRoleId() {
		return getCloudStorageManager().getRegion().getAccountResource().getActiveUser().getRoleId();
	}
	
	public CloudEndpoint getEndpoint(){
		return getCloudStorageManager().getEndpoint();
	}
	
	private String internalGetCloudTypeId(){
		String cloudServiceId = getCloudStorageManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
		String cloudTypeId = getCloudStorageManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
		return cloudTypeId;
	}
}
