/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.cloud.plugin.ViewPluginUtil;

public class Perspective extends ClusterControlPerspectiveBase{
	public static final String Id = "com.clustercontrol.cloud.ui.Perspective";
	
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		String editorArea = layout.getEditorArea();
		
		List<ViewPluginUtil.PluginView> views = ViewPluginUtil.getPluginViews();
		
		float leftRatio = 0.25f;
		float centerRatio = 0.666f;
		float topRatio = 0.34f;
		
		Set<ViewPluginUtil.ViewPosition> posFlg = new HashSet<ViewPluginUtil.ViewPosition>();
		
		for(ViewPluginUtil.PluginView view: views){
			posFlg.add(view.getPosition());
		}
		if(!posFlg.contains(ViewPluginUtil.ViewPosition.middle) || !posFlg.contains(ViewPluginUtil.ViewPosition.bottom)){
			topRatio = 0.5f;
		}
		if(!posFlg.contains(ViewPluginUtil.ViewPosition.middle) && !posFlg.contains(ViewPluginUtil.ViewPosition.bottom) && !posFlg.contains(ViewPluginUtil.ViewPosition.top)){
			leftRatio = 0.5f;
		}
		if(!posFlg.contains(ViewPluginUtil.ViewPosition.left)){
			centerRatio = 0.75f;
		}
		
		Map<ViewPluginUtil.ViewPosition, IFolderLayout> folderLayout = new HashMap<ViewPluginUtil.ViewPosition, IFolderLayout>();
		
		folderLayout.put(ViewPluginUtil.ViewPosition.left, layout.createFolder("left", IPageLayout.LEFT, leftRatio, editorArea));
		folderLayout.put(ViewPluginUtil.ViewPosition.right, layout.createFolder("right", IPageLayout.LEFT, 1.0f, editorArea));
		folderLayout.put(null, layout.createFolder("center", IPageLayout.LEFT, centerRatio, "right"));
		folderLayout.put(ViewPluginUtil.ViewPosition.top, layout.createFolder("top", IPageLayout.TOP, topRatio, "center"));
		folderLayout.put(ViewPluginUtil.ViewPosition.bottom, layout.createFolder("bottom", IPageLayout.TOP, 1.0f, "center"));
		folderLayout.put(ViewPluginUtil.ViewPosition.middle, layout.createFolder("middle", IPageLayout.TOP, 0.5f, "bottom"));
				
		for(ViewPluginUtil.PluginView view: views){
			folderLayout.get(view.getPosition()).addView(view.getId());
		}
	}
}