/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.resources.Tag;

public class EditTagsDialog extends Dialog {
	private Table table;
	private Button btnAdd;
	private Button btnEdit;
	private Button btnRemove;
	
	private List<Tag> input = new ArrayList<>();
	private List<Tag> output = new ArrayList<>();

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	private String strName = messages.getString("word.name");
	private String strValue = messages.getString("word.value");
	private String strAdd = messages.getString("word.add");
	private String strEdit = messages.getString("word.edit");
	private String strDelete = messages.getString("word.delete");
	private String strEditTagsDialog = messages.getString("caption.edit_tag_dialog");
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditTagsDialog(Shell parentShell, List<Tag> input) {
		super(parentShell);
		this.input = input;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.verticalSpacing = 10;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		table.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				btnEdit.setEnabled(true);
				btnRemove.setEnabled(true);
			}
		});
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 4);
		gd_table.widthHint = 378;
		table.setLayoutData(gd_table);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn tableColumn = new TableColumn(table, SWT.NONE);
		tableColumn.setWidth(160);
		tableColumn.setText(strName);
		
		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(260);
		tableColumn_1.setText(strValue);
		
		btnAdd = new Button(container, SWT.NONE);
		btnAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EditTagDialog dialog = new EditTagDialog(EditTagsDialog.this.getShell());
				if (dialog.open() == Window.OK) {
					TableItem item = new TableItem(table, SWT.NONE);
					item.setText(dialog.getName());
					item.setText(1, dialog.getValue());
				}
			}
		});
		btnAdd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnAdd.setText(strAdd);
		
		btnEdit = new Button(container, SWT.NONE);
		btnEdit.setEnabled(false);
		btnEdit.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = table.getSelection();
				if (items == null || items.length == 0) {
					return;
				}
				TableItem item = items[0];
				EditTagDialog dialog = new EditTagDialog(EditTagsDialog.this.getShell(), item.getText(), item.getText(1));
				if (dialog.open() == Window.OK) {
					item.setText(dialog.getName());
					item.setText(1, dialog.getValue());
				}
			}
		});
		btnEdit.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnEdit.setText(strEdit);
		
		btnRemove = new Button(container, SWT.NONE);
		btnRemove.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = table.getSelection();
				if (items == null || items.length == 0) {
					return;
				}
				TableItem item = items[0];
				item.dispose();
				btnEdit.setEnabled(false);
				btnRemove.setEnabled(false);
			}
		});
		btnRemove.setEnabled(false);
		btnRemove.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnRemove.setText(strDelete);
		new Label(container, SWT.NONE);
		
		if (!input.isEmpty()) {
			for (Tag t: input) {
				TableItem item = new TableItem(table, SWT.NONE);
				item.setText(t.name);
				item.setText(1, t.value);
			}
		}

		return container;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strEditTagsDialog);
	}
	
	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(629, 581);
	}

	public List<Tag> getOutput() {
		return output;
	}
	
	@Override
	protected void okPressed() {
		for (TableItem item: table.getItems()) {
			output.add(new Tag(item.getText(), item.getText(1)));
		}
		setReturnCode(OK);
		close();
	}
}
