/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;

public class SelectSecurityGroupsDialog extends Dialog {
	public interface IInitializer{
		void setup(org.eclipse.swt.widgets.List securityGroups);
	}
	
	public class Initializer implements IInitializer{
		@Override
		public void setup(org.eclipse.swt.widgets.List securityGroups) {
		}
	}
	
	private IInitializer initializer = new Initializer();
	
	public void setInitializer(IInitializer initializer){
		this.initializer = initializer;
	}
	
	private List<String> input;
	private List<String> output;

	private org.eclipse.swt.widgets.List securityGroups;

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strSelectSecurityGroup = messages.getString("word.select_security_group");
//	private String strSecuritySettings = messages.getString("word.security_settings");
	private String strSelectSecurityGroupsDialog = messages.getString("caption.select_security_groups_dialog");
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public SelectSecurityGroupsDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		GridLayout gl_container = new GridLayout(1, false);
		gl_container.marginTop = 10;
		gl_container.verticalSpacing = 10;
		container.setLayout(gl_container);
		
		Group group_1 = new Group(container, SWT.NONE);
		group_1.setLayout(new GridLayout(1, false));
		GridData gd_group_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_group_1.heightHint = 187;
		gd_group_1.widthHint = 572;
		group_1.setLayoutData(gd_group_1);
		group_1.setText(strSelectSecurityGroup + strSeparator);
		
		securityGroups = new org.eclipse.swt.widgets.List(group_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		GridData gd_securityGroups = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_securityGroups.heightHint = 172;
		gd_securityGroups.widthHint = 539;
		securityGroups.setLayoutData(gd_securityGroups);
		securityGroups.select(0);

		//　項目初期化
		{
			initializer.setup(securityGroups);
		}
		
		// 入力値をコントロールに反映。
			
		if (input != null) {
			java.util.List<Integer> selections = new ArrayList<Integer>();
			int size = securityGroups.getItems().length;
			for (int i = 0; i < size; ++i) {
				String selectable = (String)securityGroups.getData(Integer.toString(i));
				for (String securityGroupId: input) {
					if (selectable.equals(securityGroupId)) {
						selections.add(i);
						break;
					}
				}
			}
			int[] indices = new int[selections.size()];
			for (int i = 0; i < selections.size(); ++i) {
				indices[i] = selections.get(i);
			}
			securityGroups.select(indices);
		}

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}
	
	@Override
	protected void okPressed() {
		output = new ArrayList<String>();
		int[] indices = securityGroups.getSelectionIndices();
		for (int index: indices) {
			output.add((String)securityGroups.getData(Integer.toString(index)));
		}
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strSelectSecurityGroupsDialog);
	}

	public void setInput(List<String> input) {
		assert input != null;
		this.input = input;
	}

	public List<String> getOutput() {
		return output;
	}
}
