/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.cloudn.base.Activator;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloudn.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
import com.clustercontrol.ws.cloudn.InvalidRole_Exception;
import com.clustercontrol.ws.cloudn.InvalidUserPass_Exception;

public class ResetPasswordAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.cloudn.base.ui.views.actions.ResetPasswordAction";
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgResetPasswordConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"caption.instance_password", "word.reset"});

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)selection.getFirstElement();
		if (instance.getState() != null && instance.getState().equalsIgnoreCase("stopped")) {
			return true;
		}
		return false;
	}

	@Override
	protected void invoke(IAction action) throws InvocationException {
		final ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgResetPasswordConfirm + "\nInstanceId:" + instance.getInstanceId())){
			try {
				Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class).resetPassword(
					AccountControlUtil.getRoleId(instance.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId()),
					instance.getCloudInstanceManager().getRegion().getRegion(),
					instance.getInstanceId()
				);
				
				// Password を追跡して別ダイアログに表示する
				try {
					JobTrackingService.trackPassword(viewPart, instance);
				} catch (InvalidStateException e) {
						throw new InvocationException(e);
				}
				
			} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
				throw new InvocationException(e);
			}
		}
	}
}