/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.cloudn.ErrorCode;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.QueryAsyncJobResultResponse;
import com.clustercontrol.cloud.cloudn.util.CloudnConstants;
import com.clustercontrol.cloud.util.Tuple;
import com.clustercontrol.ws.cloudn.AttachStorageResult;
import com.clustercontrol.ws.cloudn.DeleteInstanceResult;
import com.clustercontrol.ws.cloudn.JobResult;
import com.clustercontrol.ws.cloudn.PasswordResult;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class CloudnAsynchJobTrackingOperator {
    private static LinkedHashMap<Tuple, JobId> jobIdMap = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registJobId(Tuple tuple, String jobId) {
        CloudnAsynchJobTrackingOperator.cleanup();
        LinkedHashMap<Tuple, JobId> linkedHashMap = jobIdMap;
        synchronized (linkedHashMap) {
            if (jobIdMap.containsKey(tuple)) {
                jobIdMap.remove(tuple);
            }
            jobIdMap.put(tuple, new JobId(jobId, new Date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findJobId(Tuple tuple) throws CloudManagerFault {
        boolean isAvaillable = true;
        String jobId = null;
        LinkedHashMap<Tuple, JobId> linkedHashMap = jobIdMap;
        synchronized (linkedHashMap) {
            if (jobIdMap.containsKey(tuple)) {
                if (new Date().getTime() - jobIdMap.get(tuple).getRegistDate().getTime() > CloudnConstants.KEEP_TRACKING_JOB_ID_PERIOD) {
                    isAvaillable = false;
                } else {
                    jobId = jobIdMap.get(tuple).id;
                }
            }
        }
        if (!isAvaillable) {
            CloudnAsynchJobTrackingOperator.cleanup();
        }
        if (jobId == null) {
            StringBuffer sb = new StringBuffer();
            for (Object o : tuple.toArray()) {
                sb.append(o.toString() + " ");
            }
            if (sb.length() >= 1) {
                sb.setLength(sb.length() - 1);
            }
            throw ErrorCode.JOB_ID_UNREGISTERED.cloudManagerFault(sb);
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        LinkedHashMap<Tuple, JobId> linkedHashMap = jobIdMap;
        synchronized (linkedHashMap) {
            for (Map.Entry<Tuple, JobId> entry : new LinkedHashMap<Tuple, JobId>(jobIdMap).entrySet()) {
                if (new Date().getTime() - entry.getValue().getRegistDate().getTime() <= CloudnConstants.KEEP_TRACKING_JOB_ID_PERIOD) break;
                jobIdMap.remove(entry.getKey());
            }
        }
    }

    public static <T extends JobResult> T getJobResult(CloudnCompute compute, String jobId, Class<T> clazz) throws CloudManagerFault {
        JobResult jobResult = null;
        QueryAsyncJobResultResponse response = compute.queryAsyncJobResult(jobId);
        if (clazz.equals(PasswordResult.class)) {
            PasswordResult result = new PasswordResult();
            if (response.jobresult != null && response.jobresult.virtualmachine != null) {
                result.setPassword(response.jobresult.virtualmachine.password);
            }
            jobResult = result;
        } else {
            jobResult = clazz.equals(AttachStorageResult.class) ? new AttachStorageResult() : (clazz.equals(DeleteInstanceResult.class) ? new DeleteInstanceResult() : new JobResult(){});
        }
        jobResult.setStatusByCode(Integer.parseInt(response.jobstatus));
        if (jobResult.getStatus().equals((Object)JobResult.JobStatus.failure)) {
            jobResult.setErrorCode(String.valueOf(response.jobresult.errorcode));
            jobResult.setErrorText(response.jobresult.errortext);
        }
        return (T)jobResult;
    }

    public static class JobId {
        private String id;
        private Date registDate;

        public JobId(String id, Date registDate) {
            this.id = id;
            this.registDate = registDate;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Date getRegistDate() {
            return this.registDate;
        }

        public void setRegistDate(Date registDate) {
            this.registDate = registDate;
        }
    }
}

