/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.cloudn.CloudnOptionPropertyConstants;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagement_VPC;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.DeployVirtualMachineRequest;
import com.clustercontrol.cloud.cloudn.rest.SecurityGroup;
import com.clustercontrol.cloud.cloudn.rest.Template;
import com.clustercontrol.cloud.cloudn.rest.VirtualMachine;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.clustercontrol.cloud.persistence.Transactional;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNullByDefault;

@Transactional(value=Transactional.TransactionType.Supported)
@NonNullByDefault(value=false)
public class CloudnResourceManagement_FLAT
extends CloudnResourceManagement_VPC {
    @Override
    protected String getComputeId() {
        return "compute";
    }

    @Override
    protected String getServiceId() {
        return "cloudn_flat";
    }

    @Override
    protected DeployVirtualMachineRequest getCreateInstanceRequest(String id, String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(InstanceDetail.class);
        InstanceDetail detail = (InstanceDetail)or.readValue(instanceDetail);
        DeployVirtualMachineRequest deployRequest = new DeployVirtualMachineRequest();
        deployRequest.serviceofferingid = this.getInstanceFlavorInternal((String)flavor).id;
        deployRequest.templateid = (String)CloudnResourceManagement_FLAT.parseImageId(imageId).get(0, String.class);
        deployRequest.zoneid = this.getZoneInternal((String)zone).id;
        deployRequest.networkids = null;
        deployRequest.displayname = id;
        deployRequest.group = detail.group;
        String s = "";
        for (String securityGroup : detail.securityGroups) {
            if (!s.isEmpty()) {
                s = s + ',';
            }
            s = s + securityGroup;
        }
        deployRequest.securitygroupnames = s;
        return deployRequest;
    }

    @Override
    protected void setupIpAddress(IResourceManagement.Instance instance, VirtualMachine vm) throws CloudManagerFault {
        instance.setIpAddress(vm.nic.get((int)0).ipaddress);
        instance.setHostName(TEMP_HOSTNAME);
    }

    @Override
    protected void registStoredInstanceBackupData(VirtualMachine vm, Template template, List<CloudnResourceManagement_VPC.AttachedStorage> snapshotIds) throws JsonProcessingException, CloudManagerFault {
        String backupId = CloudnResourceManagement_FLAT.createImageId(template.id, template.zonename);
        BackupedInstanceDetail backupedData = new BackupedInstanceDetail();
        backupedData.instanceId = vm.id;
        backupedData.name = vm.displayname;
        backupedData.flavor = vm.serviceofferingid;
        backupedData.zone = vm.zonename;
        backupedData.createTime = this.convertDate(template.created);
        backupedData.attachedStorages = new ArrayList<CloudnResourceManagement_VPC.AttachedStorage>(snapshotIds);
        backupedData.tags = new ArrayList<Tag>();
        for (com.clustercontrol.cloud.cloudn.rest.Tag t : vm.tags) {
            backupedData.tags.add(new Tag(t.key, t.value));
        }
        backupedData.instanceDetail = new InstanceDetail();
        backupedData.instanceDetail.securityGroups = new ArrayList<String>();
        for (SecurityGroup securityGroup : vm.securitygroup) {
            backupedData.instanceDetail.securityGroups.add(securityGroup.name);
        }
        backupedData.instanceDetail.group = vm.group;
        ObjectMapper om = new ObjectMapper();
        ObjectWriter ow = om.writerWithType(BackupedInstanceDetail.class);
        String backupedDetail = ow.writeValueAsString((Object)backupedData);
        this.getStore().put(RT_InstanceBackup, backupId, backupedDetail);
    }

    @Override
    protected void deleteRelationalSnapshot(String instanceBackupId) throws CloudManagerFault {
        BackupedInstanceDetail detail;
        CloudnCompute compute = this.getCloudnEndpoint();
        String resource = this.getStore().get(RT_InstanceBackup, instanceBackupId);
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        try {
            detail = (BackupedInstanceDetail)or.readValue(resource);
        }
        catch (IOException e1) {
            throw new InternalManagerError((Throwable)e1);
        }
        for (CloudnResourceManagement_VPC.AttachedStorage snapshotId : detail.attachedStorages) {
            try {
                compute.deleteSnapshot(snapshotId.snapshotId, null);
            }
            catch (RestfulApplicationException e) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected IResourceManagement.InstanceBackup createInternalInstanceBackup(String id) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        ObjectWriter ow = om.writerWithType(InstanceDetail.class);
        String backupDetail = this.getStore().get(RT_InstanceBackup, id);
        BackupedInstanceDetail backuped = (BackupedInstanceDetail)or.readValue(backupDetail);
        IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
        instanceBackup.setResourceType(RT_InstanceBackup);
        instanceBackup.setInstanceBackupId(id);
        instanceBackup.setInstanceId(backuped.instanceId);
        instanceBackup.setCreateTime(backuped.createTime);
        instanceBackup.setBackupedData(new IResourceManagement.InstanceBackup.BackupedData());
        instanceBackup.getBackupedData().setName(backuped.name);
        instanceBackup.getBackupedData().setFlavor(backuped.flavor);
        instanceBackup.getBackupedData().setZone(backuped.zone);
        instanceBackup.getBackupedData().setTags(backuped.tags);
        instanceBackup.getBackupedData().setInstanceDetail(ow.writeValueAsString((Object)backuped.instanceDetail));
        return instanceBackup;
    }

    @Override
    protected boolean isInstanceBackupCreating(String instanceBackupId) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        BackupedInstanceDetail detail = (BackupedInstanceDetail)or.readValue(this.getStore().get(RT_InstanceBackup, instanceBackupId));
        return new Date().getTime() - detail.createTime.getTime() < Long.parseLong(CloudnOptionPropertyConstants.cloudn_flat_until_template_created.value());
    }

    @Override
    protected CloudnResourceManagement_VPC.RestoreInfo internalRestoreInstance(String facilityId, String instanceBackupId, String name, String flavor, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault, JsonProcessingException, IOException {
        String value = this.getStore().get(RT_InstanceBackup, instanceBackupId);
        ObjectMapper om = new ObjectMapper();
        BackupedInstanceDetail backuped = (BackupedInstanceDetail)om.reader(BackupedInstanceDetail.class).readValue(value);
        backuped.name = name != null ? name : backuped.name;
        String string = backuped.flavor = flavor != null ? flavor : backuped.flavor;
        if (instanceDetail != null) {
            InstanceDetail override = (InstanceDetail)om.reader(InstanceDetail.class).readValue(instanceDetail);
            if (backuped.instanceDetail == null) {
                backuped.instanceDetail = override;
            } else {
                backuped.instanceDetail.group = override.group != null ? override.group : backuped.instanceDetail.group;
                backuped.instanceDetail.securityGroups = override.securityGroups != null ? override.securityGroups : backuped.instanceDetail.securityGroups;
                backuped.instanceDetail.attachingDisk = override.attachingDisk != null ? override.attachingDisk : backuped.instanceDetail.attachingDisk;
            }
        }
        ArrayList<Tag> tagsTemp = new ArrayList<Tag>(tags);
        block0: for (Tag t : backuped.tags) {
            if (tagsTemp.isEmpty()) break;
            Iterator iter = tagsTemp.iterator();
            while (iter.hasNext()) {
                Tag override = (Tag)iter.next();
                if (!t.getKey().equals(override.getKey())) continue;
                t.setValue(override.getValue());
                iter.remove();
                continue block0;
            }
        }
        for (Tag t : tagsTemp) {
            backuped.tags.add(t);
        }
        String backupedDetail = om.writerWithType(InstanceDetail.class).writeValueAsString((Object)backuped.instanceDetail);
        return new CloudnResourceManagement_VPC.RestoreInfo(this.internalCreateInstance(facilityId, backuped.name, backuped.flavor, instanceBackupId, backuped.zone, backupedDetail, backuped.tags), backuped.attachedStorages, backuped.instanceDetail.attachingDisk);
    }

    protected static class InstanceDetail {
        public List<String> securityGroups = Collections.emptyList();
        public String group = "";
        public Boolean attachingDisk;

        protected InstanceDetail() {
        }
    }

    protected static class BackupedInstanceDetail {
        public String instanceId;
        public String name;
        public String flavor;
        public String zone;
        public List<CloudnResourceManagement_VPC.AttachedStorage> attachedStorages;
        public List<Tag> tags;
        public Date createTime;
        public InstanceDetail instanceDetail;

        protected BackupedInstanceDetail() {
        }
    }
}

