/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.PlatformKind;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StorageAttachmentStateKind;
import com.clustercontrol.cloud.bean.StorageStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.bean.Zone;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import javax.xml.bind.annotation.XmlTransient;

public interface IResourceManagement {
    public void setAccessDestination(ICredential var1, IRegion var2);

    public void setStore(IStore var1);

    public ICredential getCledential();

    public IRegion getRegion();

    public void disconnect();

    public Instance createInstance(String var1, String var2, String var3, String var4, String var5, String var6, List<Tag> var7) throws CloudManagerFault;

    public Instance restoreInstance(String var1, String var2, String var3, String var4, String var5, String var6, List<Tag> var7) throws CloudManagerFault;

    public void deleteInstance(String var1) throws CloudManagerFault;

    public Instance getInstance(String var1) throws CloudManagerFault;

    public List<Instance> getInstances(String ... var1) throws CloudManagerFault;

    public List<Instance> getInstances(List<String> var1) throws CloudManagerFault;

    public InstanceStateChange startInstance(String var1) throws CloudManagerFault;

    public InstanceStateChange stopInstance(String var1) throws CloudManagerFault;

    public List<String> getInstanceFlavors() throws CloudManagerFault;

    public List<String> getStorageFlavors() throws CloudManagerFault;

    public List<Zone> getZones() throws CloudManagerFault;

    public Storage createStorage(String var1, String var2, int var3, String var4, String var5, String var6) throws CloudManagerFault;

    public Storage restoreStorage(String var1, String var2, String var3, Integer var4, String var5, String var6) throws CloudManagerFault;

    public void attachStorage(String var1, String var2, String var3) throws CloudManagerFault;

    public void detachStorage(String var1, String var2) throws CloudManagerFault;

    public void deleteStorage(String var1) throws CloudManagerFault;

    public Storage getStorage(String var1) throws CloudManagerFault;

    public List<Storage> getStorages(String ... var1) throws CloudManagerFault;

    public List<Storage> getStorages(List<String> var1) throws CloudManagerFault;

    public StorageBackup createStorageBackup(String var1, String var2, String var3, String var4) throws CloudManagerFault;

    public void deleteStorageBackup(String var1) throws CloudManagerFault;

    public StorageBackup getStorageBackup(String var1) throws CloudManagerFault;

    public List<StorageBackup> getStorageBackups(String ... var1) throws CloudManagerFault;

    public List<StorageBackup> getStorageBackups(List<String> var1) throws CloudManagerFault;

    public InstanceBackup createInstanceBackup(String var1, String var2, String var3, Boolean var4, String var5) throws CloudManagerFault;

    public InstanceBackup createInstanceBackup(String var1, String var2, String var3, Boolean var4, List<String> var5, String var6) throws CloudManagerFault;

    public void deleteInstanceBackup(String var1) throws CloudManagerFault;

    public InstanceBackup getInstanceBackup(String var1) throws CloudManagerFault;

    public List<InstanceBackup> getInstanceBackups(String ... var1) throws CloudManagerFault;

    public List<InstanceBackup> getInstanceBackups(List<String> var1) throws CloudManagerFault;

    public Snapshot getSnapshot(String var1) throws CloudManagerFault;

    public List<Snapshot> getSnapshots(String ... var1) throws CloudManagerFault;

    public List<Snapshot> getSnapshots(List<String> var1) throws CloudManagerFault;

    public List<Snapshot> getSnapshotsWithFilter(Filter ... var1) throws CloudManagerFault;

    public List<Snapshot> getSnapshotsWithFilter(List<Filter> var1) throws CloudManagerFault;

    public Image getImage(String var1) throws CloudManagerFault;

    public List<Image> getImages(String ... var1) throws CloudManagerFault;

    public List<Image> getImages(List<String> var1) throws CloudManagerFault;

    public List<Image> getImagesWithFilter(Filter ... var1) throws CloudManagerFault;

    public List<Image> getImagesWithFilter(List<Filter> var1) throws CloudManagerFault;

    public List<LoadBalancer> getLoadBalancers() throws CloudManagerFault;

    public void registerInstanceToLoadBalancer(String var1, String var2) throws CloudManagerFault;

    public void unregisterInstanceToLoadBalancer(String var1, String var2) throws CloudManagerFault;

    public static class LoadBalancer
    extends Resource {
        private String lbId;
        private List<String> registerdInstanceIds;
        private List<String> availableInstanceIds;

        public String getLbId() {
            return this.lbId;
        }

        public void setLbId(String lbId) {
            this.lbId = lbId;
        }

        public List<String> getRegisterdInstanceIds() {
            return this.registerdInstanceIds;
        }

        public void setRegisterdInstanceIds(List<String> registerdInstanceIds) {
            this.registerdInstanceIds = registerdInstanceIds;
        }

        public List<String> getAvailableInstanceIds() {
            return this.availableInstanceIds;
        }

        public void setAvailableInstanceIds(List<String> availableInstanceIds) {
            this.availableInstanceIds = availableInstanceIds;
        }
    }

    public static class Storage
    extends Resource {
        private String storageId;
        private String name;
        private String flavor;
        private int size;
        private String zone;
        private String snapshotId;
        private StorageStateKind state;
        private Date createTime;
        private StorageAttachment sa;

        public String getStorageId() {
            return this.storageId;
        }

        public void setStorageId(String storageId) {
            this.storageId = storageId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public void setFlavor(String flavor) {
            this.flavor = flavor;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public String getZone() {
            return this.zone;
        }

        public void setZone(String zone) {
            this.zone = zone;
        }

        public StorageAttachment getStorageAttachment() {
            return this.sa;
        }

        public void setStorageAttachment(StorageAttachment sa) {
            this.sa = sa;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public StorageStateKind getState() {
            return this.state;
        }

        public void setState(StorageStateKind state) {
            this.state = state;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public static class StorageAttachment {
            private String instanceId;
            private String device;
            private StorageAttachmentStateKind state;
            private Date attachTime;

            public StorageAttachment() {
            }

            public StorageAttachment(String instanceId, String device, StorageAttachmentStateKind state, Date attachTime) {
                this.instanceId = instanceId;
                this.device = device;
                this.state = state;
                this.attachTime = attachTime;
            }

            public String getInstanceId() {
                return this.instanceId;
            }

            public void setInstanceId(String instanceId) {
                this.instanceId = instanceId;
            }

            public String getDevice() {
                return this.device;
            }

            public void setDevice(String device) {
                this.device = device;
            }

            public StorageAttachmentStateKind getState() {
                return this.state;
            }

            public void setState(StorageAttachmentStateKind state) {
                this.state = state;
            }

            public Date getAttachTime() {
                return this.attachTime;
            }

            public void setAttachTime(Date attachTime) {
                this.attachTime = attachTime;
            }
        }
    }

    public static class InstanceBackup
    extends Resource {
        private String instanceBackupId;
        private String name;
        private String description;
        private String instanceId;
        private PlatformKind platform;
        private BackupedData backupedData;
        private Date createTime;

        public String getInstanceBackupId() {
            return this.instanceBackupId;
        }

        public void setInstanceBackupId(String instanceBackupId) {
            this.instanceBackupId = instanceBackupId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public PlatformKind getPlatform() {
            return this.platform;
        }

        public void setPlatform(PlatformKind platform) {
            this.platform = platform;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public BackupedData getBackupedData() {
            return this.backupedData;
        }

        public void setBackupedData(BackupedData backupedData) {
            this.backupedData = backupedData;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public static class BackupedData {
            private String name;
            private String flavor;
            private String zone;
            private List<Tag> tags;
            private String instanceDetail;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getFlavor() {
                return this.flavor;
            }

            public void setFlavor(String flavor) {
                this.flavor = flavor;
            }

            public String getZone() {
                return this.zone;
            }

            public void setZone(String zone) {
                this.zone = zone;
            }

            public List<Tag> getTags() {
                return this.tags;
            }

            public void setTags(List<Tag> tags) {
                this.tags = tags;
            }

            public String getInstanceDetail() {
                return this.instanceDetail;
            }

            public void setInstanceDetail(String instanceDetail) {
                this.instanceDetail = instanceDetail;
            }
        }
    }

    public static class StorageBackup
    extends Resource {
        private String storageBackupId;
        private String name;
        private String description;
        private String storageId;
        private BackupedData backupedData;
        private Date createTime;

        public String getStorageBackupId() {
            return this.storageBackupId;
        }

        public void setStorageBackupId(String storageBackupId) {
            this.storageBackupId = storageBackupId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getStorageId() {
            return this.storageId;
        }

        public void setStorageId(String storageId) {
            this.storageId = storageId;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public BackupedData getBackupedData() {
            return this.backupedData;
        }

        public void setBackupedData(BackupedData backupedData) {
            this.backupedData = backupedData;
        }

        public static class BackupedData {
            private String name;
            private String flavor;
            private String zone;
            private Integer size;
            private String storageDetail;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getFlavor() {
                return this.flavor;
            }

            public void setFlavor(String flavor) {
                this.flavor = flavor;
            }

            public String getZone() {
                return this.zone;
            }

            public void setZone(String zone) {
                this.zone = zone;
            }

            public int getSize() {
                return this.size == null ? 0 : this.size;
            }

            public void setSize(int size) {
                this.size = size;
            }

            public String getStorageDetail() {
                return this.storageDetail;
            }

            public void setStorageDetail(String storageDetail) {
                this.storageDetail = storageDetail;
            }
        }
    }

    public static class Instance
    extends Resource {
        private String instanceId;
        private String name;
        private String flavor;
        private String zone;
        private InstanceStateKind state;
        private String imageId;
        private PlatformKind platform;
        private String hostName;
        private String ipAddress;
        private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        private List<Tag> tags = new ArrayList<Tag>();

        public Instance() {
        }

        public Instance(String resourceType, String instanceId, String name, String flavor, String zone, InstanceStateKind state, String imageId, PlatformKind platform, String hostName, String ipAddress, String detail, List<BlockDeviceMapping> blockDeviceMappings, List<Tag> tags) {
            super(resourceType);
            this.instanceId = instanceId;
            this.name = name;
            this.flavor = flavor;
            this.zone = zone;
            this.state = state;
            this.imageId = imageId;
            this.platform = platform;
            this.hostName = hostName;
            this.ipAddress = ipAddress;
            this.blockDeviceMappings = blockDeviceMappings;
            this.tags = tags;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public void setFlavor(String flavor) {
            this.flavor = flavor;
        }

        public InstanceStateKind getState() {
            return this.state;
        }

        public void setState(InstanceStateKind state) {
            this.state = state;
        }

        public String getImageId() {
            return this.imageId;
        }

        public void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public PlatformKind getPlatform() {
            return this.platform;
        }

        public void setPlatform(PlatformKind platform) {
            this.platform = platform;
        }

        public String getZone() {
            return this.zone;
        }

        public void setZone(String zone) {
            this.zone = zone;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public List<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public void setTags(List<Tag> tags) {
            this.tags = tags;
        }

        public static class BlockDeviceMapping {
            private String deviceName;
            private String storageId;
            private String status;

            public BlockDeviceMapping() {
            }

            public BlockDeviceMapping(String storageId, String deviceName, String status) {
                this.storageId = storageId;
                this.deviceName = deviceName;
                this.status = status;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public void setDeviceName(String deviceName) {
                this.deviceName = deviceName;
            }

            public String getStorageId() {
                return this.storageId;
            }

            public void setStorageId(String storageId) {
                this.storageId = storageId;
            }

            public String getStatus() {
                return this.status;
            }

            public void setStatus(String status) {
                this.status = status;
            }
        }
    }

    public static abstract class Resource {
        private String resourceType;
        private Object actualResource;

        public Resource() {
        }

        public Resource(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @XmlTransient
        public Object getActualResource() {
            return this.actualResource;
        }

        public void setActualResource(Object actualResource) {
            this.actualResource = actualResource;
        }
    }

    public static interface IEndpoint {
        public String getEndpointType();

        public String getLocation();
    }

    public static interface IStore {
        public List<StoreValue> getValues(String var1) throws CloudManagerFault;

        public String get(String var1, String var2) throws CloudManagerFault;

        public void put(String var1, String var2, String var3) throws CloudManagerFault;

        public void remove(String var1, String var2) throws CloudManagerFault;

        public List<String> getIds(String var1) throws CloudManagerFault;

        public static class StoreValue {
            private String resourceType;
            private String resourceId;
            private String value;

            public StoreValue(String resourceType, String resourceId, String value) {
                this.resourceType = resourceType;
                this.resourceId = resourceId;
                this.value = value;
            }

            public String getResourceType() {
                return this.resourceType;
            }

            public void setResourceType(String resourceType) {
                this.resourceType = resourceType;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public void setResourceId(String resourceId) {
                this.resourceId = resourceId;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static interface IRegion {
        public String getName();

        public IEndpoint getEndpoint(String var1);
    }

    public static interface ICredential {
        public String getAccessKey() throws CloudManagerFault;

        public String getSecretKey() throws CloudManagerFault;
    }

    public static enum ErrorCode {
        Resource_InvalidStorage_NotFound("message.error.resource.invalidstorage.not_found"),
        Resource_InvalidInstanceID_NotFound("message.error.resource.invalidinstanceid.not_found"),
        Resource_InvalidImageID_NotFound("message.error.resource.invalidimage.not_found"),
        Resource_InvalidSnapshot_NotFound("message.error.resource.invalidsnapshot.not_found"),
        Resource_Instance_Backup_Image_State_Failed("message.error.resource.instance_backup_image_state_failed");

        private String messageId;

        private ErrorCode(String messageId) {
            this.messageId = messageId;
        }

        public String getMessage(Object ... args) {
            MessageFormat messageFormat = new MessageFormat(this.getMessage());
            return messageFormat.format(args);
        }

        public String getMessage() {
            try {
                return Messages.messages().getString(this.messageId);
            }
            catch (MissingResourceException e) {
                return this.messageId;
            }
        }

        public CloudManagerFault cloudManagerFault(Object ... args) {
            return new CloudManagerFault(this.getMessage(args), this.name());
        }
    }
}

