/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.dao;

import com.clustercontrol.cloud.dao.DaoBase;
import com.clustercontrol.cloud.persistence.ApplyCurrentTime;
import com.clustercontrol.cloud.persistence.ApplyUserName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Entity
@Table(name="cc_cloud_storage_backup")
@IdClass(value=CloudStorageBackupPK.class)
public class CloudStorageBackupDao
extends DaoBase
implements Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 2609754609395972304L;
    private String storageBackupId;
    private String cloudServiceId;
    private String region;
    private String accountResourceId;
    private String snapshotName;
    private String cloudUserId;
    private String description;
    private RestoreStatus restoreStatus;
    private BackupedData backupedData;
    private Timestamp regDate;
    private String regUser;

    public CloudStorageBackupDao() {
    }

    public CloudStorageBackupDao(String storageBackupId, String cloudServiceId, String region, String accountResourceId, String snapshotName, String cloudUserId, String description, RestoreStatus restoreStatus, BackupedData backupedData, Timestamp regDate, String regUser) {
        this.storageBackupId = storageBackupId;
        this.cloudServiceId = cloudServiceId;
        this.region = region;
        this.accountResourceId = accountResourceId;
        this.snapshotName = snapshotName;
        this.cloudUserId = cloudUserId;
        this.description = description;
        this.restoreStatus = restoreStatus;
        this.setBackupedData(backupedData);
        this.regDate = regDate;
        this.regUser = regUser;
    }

    public CloudStorageBackupDao(CloudStorageBackupDao other) {
        this.storageBackupId = other.storageBackupId;
        this.cloudServiceId = other.cloudServiceId;
        this.region = other.region;
        this.accountResourceId = other.accountResourceId;
        this.snapshotName = other.snapshotName;
        this.cloudUserId = other.cloudUserId;
        this.description = other.description;
        this.restoreStatus = other.restoreStatus;
        this.setBackupedData(new BackupedData(other.backupedData));
        this.regDate = other.regDate;
        this.regUser = other.regUser;
    }

    @Column(name="storage_buckupid_id")
    @Id
    public String getStorageBackupId() {
        return this._persistence_get_storageBackupId();
    }

    public void setStorageBackupId(String storageBackupId) {
        this._persistence_set_storageBackupId(storageBackupId);
    }

    @Column(name="cloud_Service_id")
    public String getCloudServiceId() {
        return this._persistence_get_cloudServiceId();
    }

    public void setCloudServiceId(String cloudServiceId) {
        this._persistence_set_cloudServiceId(cloudServiceId);
    }

    @Column(name="region")
    @Id
    public String getRegion() {
        return this._persistence_get_region();
    }

    public void setRegion(String region) {
        this._persistence_set_region(region);
    }

    @Column(name="account_resource_id")
    @Id
    public String getAccountResourceId() {
        return this._persistence_get_accountResourceId();
    }

    public void setAccountResourceId(String accountResourceId) {
        this._persistence_set_accountResourceId(accountResourceId);
    }

    @Column(name="name")
    public String getSnapshotName() {
        return this._persistence_get_snapshotName();
    }

    public void setSnapshotName(String snapshotName) {
        this._persistence_set_snapshotName(snapshotName);
    }

    @Column(name="cloud_user_id")
    public String getCloudUserId() {
        return this._persistence_get_cloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this._persistence_set_cloudUserId(cloudUserId);
    }

    @Column(name="description")
    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    @Column(name="restore_status")
    @Enumerated(value=EnumType.STRING)
    public RestoreStatus getRestoreStatus() {
        return this._persistence_get_restoreStatus();
    }

    public void setRestoreStatus(RestoreStatus restoreStatus) {
        this._persistence_set_restoreStatus(restoreStatus);
    }

    @Embedded
    public BackupedData getBackupedData() {
        return this._persistence_get_backupedData();
    }

    public void setBackupedData(BackupedData backupedData) {
        this._persistence_set_backupedData(backupedData);
    }

    @Column(name="reg_date")
    @ApplyCurrentTime(onlyPersist=true)
    public Timestamp getRegDate() {
        return this._persistence_get_regDate();
    }

    public void setRegDate(Timestamp regDate) {
        this._persistence_set_regDate(regDate);
    }

    @Column(name="reg_user")
    @ApplyUserName(onlyPersist=true)
    public String getRegUser() {
        return this._persistence_get_regUser();
    }

    public void setRegUser(String regUser) {
        this._persistence_set_regUser(regUser);
    }

    public String toString() {
        return "CloudStorageBackupDao [snapshotId=" + this._persistence_get_storageBackupId() + ", cloudServiceId=" + this._persistence_get_cloudServiceId() + ", region=" + this._persistence_get_region() + ", accountResourceId=" + this._persistence_get_accountResourceId() + ", snapshotName=" + this._persistence_get_snapshotName() + ", cloudUserId=" + this._persistence_get_cloudUserId() + ", description=" + this._persistence_get_description() + ", restoreStatus=" + (Object)((Object)this._persistence_get_restoreStatus()) + ", backupedData=" + this._persistence_get_backupedData() + ", regDate=" + this._persistence_get_regDate() + ", regUser=" + this._persistence_get_regUser() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloudStorageBackupDao other = (CloudStorageBackupDao)obj;
        if (this._persistence_get_accountResourceId() == null ? other._persistence_get_accountResourceId() != null : !this._persistence_get_accountResourceId().equals(other._persistence_get_accountResourceId())) {
            return false;
        }
        if (this._persistence_get_backupedData() == null ? other._persistence_get_backupedData() != null : !this._persistence_get_backupedData().equals(other._persistence_get_backupedData())) {
            return false;
        }
        if (this._persistence_get_cloudServiceId() == null ? other._persistence_get_cloudServiceId() != null : !this._persistence_get_cloudServiceId().equals(other._persistence_get_cloudServiceId())) {
            return false;
        }
        if (this._persistence_get_cloudUserId() == null ? other._persistence_get_cloudUserId() != null : !this._persistence_get_cloudUserId().equals(other._persistence_get_cloudUserId())) {
            return false;
        }
        if (this._persistence_get_description() == null ? other._persistence_get_description() != null : !this._persistence_get_description().equals(other._persistence_get_description())) {
            return false;
        }
        if (this._persistence_get_regDate() == null ? other._persistence_get_regDate() != null : !this._persistence_get_regDate().equals(other._persistence_get_regDate())) {
            return false;
        }
        if (this._persistence_get_regUser() == null ? other._persistence_get_regUser() != null : !this._persistence_get_regUser().equals(other._persistence_get_regUser())) {
            return false;
        }
        if (this._persistence_get_region() == null ? other._persistence_get_region() != null : !this._persistence_get_region().equals(other._persistence_get_region())) {
            return false;
        }
        if (this._persistence_get_restoreStatus() != other._persistence_get_restoreStatus()) {
            return false;
        }
        if (this._persistence_get_storageBackupId() == null ? other._persistence_get_storageBackupId() != null : !this._persistence_get_storageBackupId().equals(other._persistence_get_storageBackupId())) {
            return false;
        }
        return !(this._persistence_get_snapshotName() == null ? other._persistence_get_snapshotName() != null : !this._persistence_get_snapshotName().equals(other._persistence_get_snapshotName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._persistence_get_accountResourceId() == null ? 0 : this._persistence_get_accountResourceId().hashCode());
        result = 31 * result + (this._persistence_get_backupedData() == null ? 0 : this._persistence_get_backupedData().hashCode());
        result = 31 * result + (this._persistence_get_cloudServiceId() == null ? 0 : this._persistence_get_cloudServiceId().hashCode());
        result = 31 * result + (this._persistence_get_cloudUserId() == null ? 0 : this._persistence_get_cloudUserId().hashCode());
        result = 31 * result + (this._persistence_get_description() == null ? 0 : this._persistence_get_description().hashCode());
        result = 31 * result + (this._persistence_get_regDate() == null ? 0 : this._persistence_get_regDate().hashCode());
        result = 31 * result + (this._persistence_get_regUser() == null ? 0 : this._persistence_get_regUser().hashCode());
        result = 31 * result + (this._persistence_get_region() == null ? 0 : this._persistence_get_region().hashCode());
        result = 31 * result + (this._persistence_get_restoreStatus() == null ? 0 : this._persistence_get_restoreStatus().hashCode());
        result = 31 * result + (this._persistence_get_storageBackupId() == null ? 0 : this._persistence_get_storageBackupId().hashCode());
        result = 31 * result + (this._persistence_get_snapshotName() == null ? 0 : this._persistence_get_snapshotName().hashCode());
        return result;
    }

    public CloudStorageBackupPK getId() {
        return new CloudStorageBackupPK(this.getStorageBackupId(), this.getRegion(), this.getAccountResourceId());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CloudStorageBackupDao();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "region") {
            return this.region;
        }
        if (string == "cloudUserId") {
            return this.cloudUserId;
        }
        if (string == "backupedData") {
            return this.backupedData;
        }
        if (string == "cloudServiceId") {
            return this.cloudServiceId;
        }
        if (string == "accountResourceId") {
            return this.accountResourceId;
        }
        if (string == "snapshotName") {
            return this.snapshotName;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "regDate") {
            return this.regDate;
        }
        if (string == "regUser") {
            return this.regUser;
        }
        if (string == "storageBackupId") {
            return this.storageBackupId;
        }
        if (string == "restoreStatus") {
            return this.restoreStatus;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "region") {
            this.region = (String)object;
            return;
        }
        if (string == "cloudUserId") {
            this.cloudUserId = (String)object;
            return;
        }
        if (string == "backupedData") {
            this.backupedData = (BackupedData)object;
            return;
        }
        if (string == "cloudServiceId") {
            this.cloudServiceId = (String)object;
            return;
        }
        if (string == "accountResourceId") {
            this.accountResourceId = (String)object;
            return;
        }
        if (string == "snapshotName") {
            this.snapshotName = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "regDate") {
            this.regDate = (Timestamp)object;
            return;
        }
        if (string == "regUser") {
            this.regUser = (String)object;
            return;
        }
        if (string == "storageBackupId") {
            this.storageBackupId = (String)object;
            return;
        }
        if (string == "restoreStatus") {
            this.restoreStatus = (RestoreStatus)((Object)object);
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_region() {
        this._persistence_checkFetched("region");
        return this.region;
    }

    public void _persistence_set_region(String string) {
        this._persistence_checkFetchedForSet("region");
        this._persistence_propertyChange("region", this.region, string);
        this.region = string;
    }

    public String _persistence_get_cloudUserId() {
        this._persistence_checkFetched("cloudUserId");
        return this.cloudUserId;
    }

    public void _persistence_set_cloudUserId(String string) {
        this._persistence_checkFetchedForSet("cloudUserId");
        this._persistence_propertyChange("cloudUserId", this.cloudUserId, string);
        this.cloudUserId = string;
    }

    public BackupedData _persistence_get_backupedData() {
        this._persistence_checkFetched("backupedData");
        return this.backupedData;
    }

    public void _persistence_set_backupedData(BackupedData backupedData) {
        this._persistence_checkFetchedForSet("backupedData");
        this._persistence_propertyChange("backupedData", this.backupedData, backupedData);
        this.backupedData = backupedData;
    }

    public String _persistence_get_cloudServiceId() {
        this._persistence_checkFetched("cloudServiceId");
        return this.cloudServiceId;
    }

    public void _persistence_set_cloudServiceId(String string) {
        this._persistence_checkFetchedForSet("cloudServiceId");
        this._persistence_propertyChange("cloudServiceId", this.cloudServiceId, string);
        this.cloudServiceId = string;
    }

    public String _persistence_get_accountResourceId() {
        this._persistence_checkFetched("accountResourceId");
        return this.accountResourceId;
    }

    public void _persistence_set_accountResourceId(String string) {
        this._persistence_checkFetchedForSet("accountResourceId");
        this._persistence_propertyChange("accountResourceId", this.accountResourceId, string);
        this.accountResourceId = string;
    }

    public String _persistence_get_snapshotName() {
        this._persistence_checkFetched("snapshotName");
        return this.snapshotName;
    }

    public void _persistence_set_snapshotName(String string) {
        this._persistence_checkFetchedForSet("snapshotName");
        this._persistence_propertyChange("snapshotName", this.snapshotName, string);
        this.snapshotName = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public Timestamp _persistence_get_regDate() {
        this._persistence_checkFetched("regDate");
        return this.regDate;
    }

    public void _persistence_set_regDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("regDate");
        this._persistence_propertyChange("regDate", this.regDate, timestamp);
        this.regDate = timestamp;
    }

    public String _persistence_get_regUser() {
        this._persistence_checkFetched("regUser");
        return this.regUser;
    }

    public void _persistence_set_regUser(String string) {
        this._persistence_checkFetchedForSet("regUser");
        this._persistence_propertyChange("regUser", this.regUser, string);
        this.regUser = string;
    }

    public String _persistence_get_storageBackupId() {
        this._persistence_checkFetched("storageBackupId");
        return this.storageBackupId;
    }

    public void _persistence_set_storageBackupId(String string) {
        this._persistence_checkFetchedForSet("storageBackupId");
        this._persistence_propertyChange("storageBackupId", this.storageBackupId, string);
        this.storageBackupId = string;
    }

    public RestoreStatus _persistence_get_restoreStatus() {
        this._persistence_checkFetched("restoreStatus");
        return this.restoreStatus;
    }

    public void _persistence_set_restoreStatus(RestoreStatus restoreStatus) {
        this._persistence_checkFetchedForSet("restoreStatus");
        this._persistence_propertyChange("restoreStatus", (Object)this.restoreStatus, (Object)restoreStatus);
        this.restoreStatus = restoreStatus;
    }

    @Embeddable
    public static class BackupedData
    implements Serializable,
    Cloneable,
    PersistenceWeaved,
    PersistenceObject,
    FetchGroupTracker,
    PersistenceWeavedFetchGroups,
    ChangeTracker,
    PersistenceWeavedChangeTracking,
    PersistenceWeavedRest {
        private static final long serialVersionUID = 4522363574206488823L;
        private String storageId;
        protected transient PropertyChangeListener _persistence_listener;
        @XmlTransient
        protected FetchGroup _persistence_fetchGroup;
        protected transient boolean _persistence_shouldRefreshFetchGroup;
        protected transient Session _persistence_session;
        protected transient List _persistence_relationshipInfo;
        protected transient Link _persistence_href;

        public BackupedData() {
        }

        public BackupedData(String storageId, String storageName, Integer storageSize, String zone, String detail) {
            this.storageId = storageId;
        }

        public BackupedData(BackupedData other) {
            this.storageId = other.storageId;
        }

        @Column(name="storage_id")
        public String getStorageId() {
            return this._persistence_get_storageId();
        }

        public void setStorageId(String storageId) {
            this._persistence_set_storageId(storageId);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._persistence_get_storageId() == null ? 0 : this._persistence_get_storageId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BackupedData other = (BackupedData)obj;
            return !(this._persistence_get_storageId() == null ? other._persistence_get_storageId() != null : !this._persistence_get_storageId().equals(other._persistence_get_storageId()));
        }

        public String toString() {
            return "BackupedData [storageId=" + this._persistence_get_storageId() + "]";
        }

        public Object _persistence_post_clone() {
            this._persistence_listener = null;
            this._persistence_fetchGroup = null;
            this._persistence_session = null;
            return this;
        }

        public Object _persistence_shallow_clone() {
            return super.clone();
        }

        public Object _persistence_new(PersistenceObject persistenceObject) {
            return new BackupedData();
        }

        public Object _persistence_get(String string) {
            if (string == "storageId") {
                return this.storageId;
            }
            return null;
        }

        public void _persistence_set(String string, Object object) {
            if (string == "storageId") {
                this.storageId = (String)object;
                return;
            }
        }

        public String _persistence_get_storageId() {
            this._persistence_checkFetched("storageId");
            return this.storageId;
        }

        public void _persistence_set_storageId(String string) {
            this._persistence_checkFetchedForSet("storageId");
            this._persistence_propertyChange("storageId", this.storageId, string);
            this.storageId = string;
        }

        public PropertyChangeListener _persistence_getPropertyChangeListener() {
            return this._persistence_listener;
        }

        public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this._persistence_listener = propertyChangeListener;
        }

        public void _persistence_propertyChange(String string, Object object, Object object2) {
            if (this._persistence_listener != null && object != object2) {
                this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
            }
        }

        public Session _persistence_getSession() {
            return this._persistence_session;
        }

        public void _persistence_setSession(Session session) {
            this._persistence_session = session;
        }

        public FetchGroup _persistence_getFetchGroup() {
            return this._persistence_fetchGroup;
        }

        public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
            this._persistence_fetchGroup = fetchGroup;
        }

        public boolean _persistence_shouldRefreshFetchGroup() {
            return this._persistence_shouldRefreshFetchGroup;
        }

        public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
            this._persistence_shouldRefreshFetchGroup = bl;
        }

        public void _persistence_resetFetchGroup() {
        }

        public boolean _persistence_isAttributeFetched(String string) {
            return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
        }

        public void _persistence_checkFetched(String string) {
            if (!this._persistence_isAttributeFetched(string)) {
                EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
            }
        }

        public void _persistence_checkFetchedForSet(String string) {
            if (!this._persistence_isAttributeFetched(string)) {
                EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
            }
        }

        public List _persistence_getRelationships() {
            return this._persistence_relationshipInfo;
        }

        public void _persistence_setRelationships(List list) {
            this._persistence_relationshipInfo = list;
        }

        public Link _persistence_getHref() {
            return this._persistence_href;
        }

        public void _persistence_setHref(Link link) {
            this._persistence_href = link;
        }
    }

    public static class CloudStorageBackupPK {
        public String storageBackupId;
        public String region;
        public String accountResourceId;

        public CloudStorageBackupPK() {
        }

        public CloudStorageBackupPK(String storageBackupId, String region, String accountResourceId) {
            this.storageBackupId = storageBackupId;
            this.accountResourceId = accountResourceId;
            this.region = region;
        }

        public String getStorageBackupId() {
            return this.storageBackupId;
        }

        public String getAccountResourceId() {
            return this.accountResourceId;
        }

        public String getRegion() {
            return this.region;
        }

        public void setStorageBackupId(String storageBackupId) {
            this.storageBackupId = storageBackupId;
        }

        public void setAccountResourceId(String accountResourceId) {
            this.accountResourceId = accountResourceId;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public int hashCode() {
            int _hashCode = 0;
            if (this.storageBackupId != null) {
                _hashCode += this.storageBackupId.hashCode();
            }
            if (this.accountResourceId != null) {
                _hashCode += this.accountResourceId.hashCode();
            }
            if (this.region != null) {
                _hashCode += this.region.hashCode();
            }
            return _hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CloudStorageBackupPK)) {
                return false;
            }
            CloudStorageBackupPK pk = (CloudStorageBackupPK)obj;
            boolean eq = true;
            if (this.storageBackupId != null) {
                eq = eq && this.storageBackupId.equals(pk.getStorageBackupId());
            } else {
                boolean bl = eq = eq && pk.getStorageBackupId() == null;
            }
            if (this.accountResourceId != null) {
                eq = eq && this.accountResourceId.equals(pk.getAccountResourceId());
            } else {
                boolean bl = eq = eq && pk.getAccountResourceId() == null;
            }
            eq = this.region != null ? eq && this.region.equals(pk.getRegion()) : eq && pk.getRegion() == null;
            return eq;
        }

        public String toString() {
            StringBuffer toStringValue = new StringBuffer("[.");
            toStringValue.append(this.storageBackupId).append('.');
            toStringValue.append(this.accountResourceId).append('.');
            toStringValue.append(this.region).append('.');
            toStringValue.append(']');
            return toStringValue.toString();
        }
    }

    public static enum RestoreStatus {
        available,
        unavailable;

    }
}

