/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */


package com.clustercontrol.cloud.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;

/**
 * hinemos.propertiesファイルに設定されているプロパティ値を
 * 取得するためのユーティリティクラス
 * 
 * Hinemos3.2で標準で実装されているクラス。3.1で利用するために暫定的にVmEJBで定義する。
 * package名が異なる。
 */
public class HinemosProperties {
	/** ログ出力のインスタンス。 */
	private static Logger m_log = Logger.getLogger( HinemosProperties.class );
	
	private static final Properties properties = new Properties();
	
	static {
		FileInputStream inputStream = null;
		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";

			inputStream = new FileInputStream(propertyFile);

			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(inputStream);
		} catch (FileNotFoundException e) {
			m_log.error(e.getMessage(), e);
		} catch (IOException e) {
			m_log.error(e.getMessage(), e);
		} finally {
			if(inputStream != null){
				try {
					inputStream.close();
				} catch (IOException e) {
					m_log.error(e.getMessage(), e);
				}
			}
		}
	}
	
	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。
	 * そのキーがプロパティリストにないと、デフォルトのプロパティリスト、
	 * さらにそのデフォルト値が繰り返し調べられます。
	 * そのプロパティが見つからない場合は、null が返されます。
	 * @param key プロパティキー
	 * @return 指定されたキー値を持つこのプロパティリストの値
	 */
	public static String getProperty(String key){
		return properties.getProperty(key);
	}
	
	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。
	 * そのキーがプロパティリストにないと、デフォルトのプロパティリスト、
	 * さらにそのデフォルト値が繰り返し調べられます。
	 * そのプロパティが見つからない場合は、デフォルト値の引数が返されます。 
	 * @param key プロパティキー
	 * @param defaultValue デフォルト値
	 * @return 指定されたキー値を持つこのプロパティリストの値
	 */
	public static String getProperty(String key, String defaultValue){
		return properties.getProperty(key, defaultValue);
	}
}