/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public interface Processor<A extends Annotation> {
	void init(A annotation, Method getMethod, Method setMethod) throws Exception;

	void postLoad(Object entity) throws Exception;
	void prePersist(Object entity) throws Exception;
	void postPersist(Object entity) throws Exception;
	void preUpdate(Object entity) throws Exception;
	void postUpdate(Object entity) throws Exception;
}
