/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jdt.annotation.NonNull;

import com.clustercontrol.cloud.cloudn.rest.RTag;
import com.clustercontrol.cloud.cloudn.rest.api.ParamHolder.Param;


public class TagParamMarshaller implements MarshalParam.marshaller {
	@Override
	public @NonNull Collection<Param> marshal(Object value) {
		@SuppressWarnings("unchecked")
		List<RTag> tags = (List<RTag>)value;
		List<ParamHolder.Param> restParams = new ArrayList<>();
		for (int i = 0; i < tags.size(); ++i) {
			RTag t = tags.get(i);
			restParams.add(Param.build("tags[" + i + "].key", t.key));
			restParams.add(Param.build("tags[" + i + "].value", t.value));
		}
		return restParams;
	}
}