SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

BEGIN;
    
CREATE TABLE cc_cloud_type_mst (
	cloud_id varchar(64) NOT NULL,
	cloud_name varchar(128) NOT NULL,
	description varchar(256)
);

ALTER TABLE ONLY cc_cloud_type_mst
    ADD CONSTRAINT p_key_cc_cloud_type_mst PRIMARY KEY (cloud_id);

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_service (
    cloud_service_id character varying(64) NOT NULL,
    cloud_service_name character varying(256) NOT NULL,
    cloud_type_id character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE ONLY cc_cloud_service
    ADD CONSTRAINT p_key_cc_cloud_service PRIMARY KEY (cloud_service_id);

ALTER TABLE ONLY cc_cloud_service
    ADD CONSTRAINT f_key_cc_cloud_service_cloud_type_id FOREIGN KEY (cloud_type_id) REFERENCES cc_cloud_type_mst(cloud_id);

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_region (
    region character varying(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
    region_name character varying(256) NOT NULL,
    description character varying(256) NOT NULL
    );

ALTER TABLE ONLY cc_cloud_region
    ADD CONSTRAINT p_key_cc_cloud_region PRIMARY KEY (cloud_service_id, region);

ALTER TABLE ONLY cc_cloud_region ADD CONSTRAINT f_key_cc_cloud_region_cloud_service_id FOREIGN KEY (cloud_service_id) REFERENCES cc_cloud_service(cloud_service_id) ON DELETE CASCADE;

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_endpoint (
    ep_type character varying(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
    region character varying(64) NOT NULL,
    location character varying(256) NOT NULL
    );

ALTER TABLE ONLY cc_cloud_endpoint
    ADD CONSTRAINT p_key_cc_cloud_endpoint PRIMARY KEY (cloud_service_id, region, ep_type);

ALTER TABLE ONLY cc_cloud_endpoint
    ADD CONSTRAINT f_key_cc_cloud_endpoint_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_account_resource (
    account_resource_id character varying(64) NOT NULL,
    account_resource_name character varying(256) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
    account_id character varying(64),
    billing_detail_collector_flg smallint,
    retention_period smallint,
    billing_last_date timestamp without time zone,
    description character varying(256) NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE ONLY cc_cloud_account_resource
    ADD CONSTRAINT p_key_cc_cloud_account_resource PRIMARY KEY (account_resource_id);

ALTER TABLE ONLY cc_cloud_account_resource
    ADD CONSTRAINT u_key_cc_cloud_account_resource_account_id UNIQUE (account_id);

ALTER TABLE ONLY cc_cloud_account_resource
    ADD CONSTRAINT f_key_cc_cloud_account_resource_cloud_service_id FOREIGN KEY (cloud_service_id) REFERENCES cc_cloud_service(cloud_service_id) ON DELETE CASCADE;

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_user (
    cloud_user_id character varying(64) NOT NULL,
    account_resource_id character varying(64) NOT NULL,
    cloud_user_name character varying(128) NOT NULL,
    description character varying(256) NOT NULL,
    secret_key character varying(64) NOT NULL,
    access_key character varying(64) NOT NULL,
    cloud_user_type character varying(64) NOT NULL,
    role_id character varying(64) NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT p_key_cc_cloud_user PRIMARY KEY (cloud_user_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT u_key_cc_cloud_user_role_id UNIQUE (role_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT f_key_cc_cloud_user_role_id FOREIGN KEY (role_id) REFERENCES cc_cfg_role(role_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT f_key_cc_cloud_user_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

COMMIT;

BEGIN;

ALTER TABLE ONLY cc_cloud_account_resource
    ADD CONSTRAINT f_key_cc_cloud_account_resource_account_id FOREIGN KEY (account_id) REFERENCES cc_cloud_user(cloud_user_id) ON DELETE SET NULL;

COMMIT;


BEGIN;

--
-- Name: cc_cloud_instance; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cloud_instance (
    instance_id character varying(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
    region character varying(64) NOT NULL,
    account_resource_id character varying(64) NOT NULL,
    instance_name character varying(64),
    cloud_user_id varchar(64) NOT NULL,
    facility_id character varying(64),
    availavility_zone character varying(64) NOT NULL,
    regist_status varchar(64) NOT NULL,
	template_id varchar(64),
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

--
-- Name: p_key_cc_cloud_instance; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT p_key_cc_cloud_instance PRIMARY KEY (instance_id, region, account_resource_id);
    
ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT f_key_cc_cloud_instance_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT f_key_cc_cloud_instance_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT f_key_cc_cloud_instance_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT u_key_cc_cloud_instance_facility_id UNIQUE (facility_id);

COMMIT;


BEGIN;

CREATE TABLE cc_cloud_billing_alarm (
	plugin_id varchar(64) NOT NULL,
	alarm_id varchar(64) NOT NULL,
	alarm_name varchar(128) NOT NULL,
	description varchar(256),
	owner_role_id varchar(64) NOT NULL,
	facility_id varchar(64) NOT NULL,
	monitor_kind varchar(64) NOT NULL,
	threshold_info_limit double precision,
	threshold_warn_limit double precision,
	notify_group_id varchar(1024) NOT NULL,
	unit varchar(64) NOT NULL,
	application varchar(64) NOT NULL,
	last_notified_day timestamp without time zone,
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64),
	valid_flg smallint
);

ALTER TABLE ONLY cc_cloud_billing_alarm
    ADD CONSTRAINT p_key_cc_cloud_billing_alarm PRIMARY KEY (alarm_id);

ALTER TABLE ONLY cc_cloud_billing_alarm
    ADD CONSTRAINT f_key_cc_cloud_billing_alarm_owner_role_id FOREIGN KEY (owner_role_id) REFERENCES cc_cfg_role(role_id);

ALTER TABLE ONLY cc_cloud_billing_alarm
    ADD CONSTRAINT f_key_cc_ccloud_billing_alarm_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id) ON DELETE CASCADE;

COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_instance_backup (
	instance_backup_id varchar(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
	region character varying(64) NOT NULL,
	account_resource_id character varying(64) NOT NULL,
	name varchar(128),
	description varchar(256),
	cloud_user_id varchar(64) NOT NULL,
	restore_status varchar(64) NOT NULL,

	facility_id varchar(64) NOT NULL,
	facility_name varchar(128),
	facility_description varchar(256),
	facility_node_name varchar(128) NOT NULL,
	instance_id varchar(64) NOT NULL,
	
	reg_date timestamp without time zone,
	reg_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT p_key_cc_cloud_instance_backup PRIMARY KEY (instance_backup_id, account_resource_id, region);

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT f_key_cc_cloud_instance_backup_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT f_key_cc_cloud_instance_backup_instance_id_account_resource_id_region FOREIGN KEY (instance_id, account_resource_id, region) REFERENCES cc_cloud_instance(instance_id, account_resource_id, region) ON DELETE CASCADE;
    
ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT f_key_cc_cloud_instance_backup_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT f_key_cc_cloud_instance_backup_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_storage (
	storage_id varchar(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
	region varchar(64) NOT NULL,
    account_resource_id character varying(64) NOT NULL,
    storage_name varchar(128),
	flavor varchar(64),
	facility_id varchar(64),
	device_index integer,
	device_type varchar(32),
	device_name varchar(128),
	availability_zone varchar(64) NOT NULL,
	regist_status varchar(64) NOT NULL,
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT p_key_cc_cloud_storage PRIMARY KEY (storage_id, region, account_resource_id);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT f_key_cc_cloud_storage_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT f_key_cc_cloud_storage_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

--    ADD CONSTRAINT f_key_cc_cloud_storage_facility_id_device_index_device_type_dev FOREIGN KEY (facility_id, device_index, device_type, device_name) REFERENCES cc_cfg_node_disk(facility_id, device_index, device_type, device_name);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT f_key_cc_cloud_storage_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON DELETE CASCADE;

    
COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_storage_backup (
	storage_buckupId_id varchar(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
	region varchar(64) NOT NULL,
	account_resource_id character varying(64) NOT NULL,
	name varchar(128),
	description varchar(256),
	cloud_user_id varchar(64) NOT NULL,
	restore_status varchar(64) NOT NULL,

	storage_id varchar(64) NOT NULL,

	reg_date timestamp without time zone,
	reg_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT p_key_cc_cloud_storage_backup PRIMARY KEY (storage_buckupId_id, region, account_resource_id);

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT f_key_cc_cloud_storage_backup_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT f_key_cc_cloud_storage_backup_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT f_key_cc_cloud_storage_backup_storage_id_region_account_resource_id FOREIGN KEY (storage_id, region, account_resource_id) REFERENCES cc_cloud_storage(storage_id, region, account_resource_id) ON DELETE CASCADE;

COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_template (
	template_id varchar(64) NOT NULL,
    cloud_service_id character varying(64) NOT NULL,
	region varchar(64) NOT NULL,
	account_resource_id character varying(64) NOT NULL,
	template_name varchar(128),
	cloud_user_id varchar(64) NOT NULL,
	image_id varchar(64) NOT NULL,
	jobunit_id varchar(64) NOT NULL,
	launch_job_id varchar(64),
	start_job_id varchar(64),
	stop_job_id varchar(64),
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT p_key_cc_cloud_template PRIMARY KEY (template_id);

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_launch_job_id FOREIGN KEY (jobunit_id, launch_job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE SET NULL;
    
ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_start_job_id FOREIGN KEY (jobunit_id, start_job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE SET NULL;
    
ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_stop_job_id FOREIGN KEY (jobunit_id, stop_job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE SET NULL;

COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_resource_store (
	account_resource_id character varying(64) NOT NULL,
	cloud_service_id character varying(64) NOT NULL,
	region character varying(64) NOT NULL,
	resource_type varchar(64) NOT NULL,
	resource_id varchar(64) NOT NULL,
	store_value text NOT NULL
);

ALTER TABLE ONLY cc_cloud_resource_store
    ADD CONSTRAINT p_key_cc_cloud_resource_store PRIMARY KEY (account_resource_id, region, resource_type, resource_id);
    
ALTER TABLE ONLY cc_cloud_resource_store
    ADD CONSTRAINT f_key_cc_cloud_resource_store_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;
    
ALTER TABLE ONLY cc_cloud_resource_store
    ADD CONSTRAINT f_key_cc_cloud_resource_store_cloud_service_id_region FOREIGN KEY (cloud_service_id, region) REFERENCES cc_cloud_region(cloud_service_id, region) ON DELETE CASCADE;

COMMIT;


BEGIN;
    
CREATE TABLE cc_cloud_auto_control (
	auto_control_id varchar(64) NOT NULL,
	account_resource_id character varying(64) NOT NULL,
	facility_id varchar(64) NOT NULL,
	resource_name varchar(64) NOT NULL,
	operation_name varchar(64) NOT NULL,
	trigger_type varchar(64) NOT NULL,
	job_schedule_id varchar(64),
	job_notyfy_id varchar(64),

	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT p_key_cc_cloud_auto_control PRIMARY KEY (auto_control_id, account_resource_id);

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT f_key_cc_cloud_auto_control_auto_control_id_account_resource_id FOREIGN KEY (auto_control_id, account_resource_id) REFERENCES cc_job_mst(job_id, jobunit_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT f_key_cc_cloud_auto_control_account_resource_id FOREIGN KEY (account_resource_id) REFERENCES cc_cloud_account_resource(account_resource_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT f_key_cc_cloud_auto_control_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT u_key_cc_cloud_auto_control_job_schedule_id UNIQUE (job_schedule_id);

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT f_key_cc_cloud_auto_control_job_schedule_id FOREIGN KEY (job_schedule_id) REFERENCES cc_job_schedule(schedule_id) ON DELETE SET NULL;

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT u_key_cc_cloud_auto_control_job_notyfy_id UNIQUE (job_notyfy_id);

ALTER TABLE ONLY cc_cloud_auto_control
    ADD CONSTRAINT f_key_cc_cloud_auto_control_job_notyfy_id FOREIGN KEY (job_notyfy_id) REFERENCES cc_notify_info(notify_id) ON DELETE SET NULL;

COMMIT;

/*
BEGIN;

CREATE TABLE cc_cloud_billing_detail (
    account_resource_id character varying(64) NOT NULL,
    target_date date NOT NULL,
    facility_id character varying(64) NOT NULL,
    facility_name character varying(128),
    category character varying(64) NOT NULL,
    category_detail character varying(128) NOT NULL,
    display_name character varying(1024) NOT NULL,
    assign_facility_id_list character varying(1024) NOT NULL,
    cost numeric,
    unit character varying(64)
);

ALTER TABLE ONLY cc_cloud_billing_detail
    ADD CONSTRAINT cc_cloud_billing_detail_pkey PRIMARY KEY (account_resource_id, target_date, facility_id, category, category_detail, display_name,assign_facility_id_list);

COMMIT;
*/

BEGIN;

CREATE TABLE cc_cloud_billing_detail (
    billing_detail_id serial NOT NULL,
    account_resource_id character varying(64) NOT NULL,
    account_resource_name character varying(256) NOT NULL,
    target_date date NOT NULL,
	resource_id varchar(64),
    category character varying(64) NOT NULL,
    category_detail character varying(128),
    display_name character varying(1024) NOT NULL,
    cost numeric,
    unit character varying(64) NOT NULL
);

ALTER TABLE ONLY cc_cloud_billing_detail
    ADD CONSTRAINT cc_cloud_billing_detail_pkey PRIMARY KEY (billing_detail_id);

COMMIT;

BEGIN;

CREATE TABLE cc_cloud_billing_detail_relation (
    relation_id serial NOT NULL,
    billing_detail_id integer NOT NULL,
    facility_id character varying(64) NOT NULL,
    facility_name character varying(128),
    relation_type character varying(64) NOT NULL
);

ALTER TABLE ONLY cc_cloud_billing_detail_relation
    ADD CONSTRAINT cc_cloud_billing_detail_relation_pkey PRIMARY KEY (relation_id);

ALTER TABLE ONLY cc_cloud_billing_detail_relation
    ADD CONSTRAINT f_key_cc_cloud_billing_detail_relation_billing_detail_id FOREIGN KEY (billing_detail_id) REFERENCES cc_cloud_billing_detail(billing_detail_id) ON DELETE CASCADE;

COMMIT;


BEGIN;

--\set ON_ERROR_STOP

INSERT INTO cc_system_privilege (role_id, system_function, system_privilege) SELECT 'HINEMOS_MODULE','CloudManagement','READ' FROM cc_system_privilege WHERE NOT EXISTS (SELECT * FROM cc_system_privilege WHERE role_id = 'HINEMOS_MODULE' AND system_function = 'CloudManagement' AND system_privilege = 'READ') limit 1;

COMMIT;