/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.EntityValidator.EntityValidationContext;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;


/**
 * インスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(CreateCloudAccountResourceRequest request) addInstance 関数} にて使用される。
 *
 */
@CustomEntityValidation(ModifyAccountResourceRequest.ModifyAccountResourceValidator.class)
public class ModifyAccountResourceRequest extends CloudRequest {
	public static class ModifyAccountResourceValidator implements CustomEntityValidator<ModifyAccountResourceRequest>, ValidationConstants {
		@Override
		public void validate(final ModifyAccountResourceRequest entity, String group, IMessagesHolder messages, EntityValidationContext context) throws ValidationFault {
			try {
				if (!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId())) {
					throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUNT_USER.cloudManagerFaultByIndex(1, SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId());
				}
			}
			catch (CloudManagerFault e) {
				throw new ValidationFault(e);
			}
		}
	}
	
	private String accountResourceId;
	private String accountResourceName;
	private String description;

	public ModifyAccountResourceRequest() {
	}	

	@ElementId("accountResourceId")
	@Identity
	@ModifiableAccountResource
	public String getAccountResourceId() {
		return accountResourceId;
	}

	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}
	
	@ElementId("accountResourceName")
	@Size(max=128)
	public String getAccountResourceName() {
		return accountResourceName;
	}
	public void setAccountResourceName(String accountResourceName) {
		this.accountResourceName = accountResourceName;
	}

	@ElementId("description")
	@Size(max = 256)
	@NotNull
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
}
