/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.IntRange;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * ストレージ作成情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addStorage(ResotoreStorageRequest request) addStorage 関数}、
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#restoreStorage(ResotoreStorageRequest request) restoreStorage 関数} にて使用される。
 *
 */
public class RestoreStorageRequest extends CloudRequest {
	private String storageBackupId;
	private String flavor;
	private String storageName;
	private Integer storageSize;
	private String zone;
	private String detail;
	
	/**
	 * ストレージ名を取得します。
	 * 
	 * @return ストレージ名。
	 */
	@ElementId("storageName")
	@Size(max = 128)
	public String getStorageName() {
		return storageName;
	}
	/**
	 * ストレージ名を指定します。
	 * 作成時には128 字以内の文字列を指定する必要があります。リストア時には、null を指定した場合、バックアップ時の値が使用されます。
	 * 
	 * @param storageName　ストレージ名。
	 */
	public void setStorageName(String storageName) {
		this.storageName = storageName;
	}
	/**
	 * ストレージサイズを取得します。
	 * 
	 * @return ストレージサイズ。
	 */
	@ElementId("storageSize")
	@IntRange(min=0)
	public Integer getStorageSize() {
		return storageSize;
	}
	/**
	 * ストレージサイズを指定します。リストア時には、null を指定した場合、バックアップ時の値が使用されます。
	 * 
	 * @param storageSize ストレージサイズ。
	 */
	public void setStorageSize(Integer storageSize) {
		this.storageSize = storageSize;
	}
	/**
	 * アベイラビリティゾーンを取得します。
	 * 
	 * @return アベイラビリティゾーン。
	 */
	public String getZone() {
		return zone;
	}
	/**
	 * アベイラビリティゾーンを指定します。リストア時には、null を指定した場合、バックアップ時の値が使用されます。
	 * 
	 * @param availabilityZone　アベイラビリティゾーン。
	 */
	public void setZone(String zone) {
		this.zone = zone;
	}
	/**
	 * スナップショットを取得します。
	 * 
	 * @return スナップショット。
	 */
	@ElementId("storageBackupId")
	@NotNull
	@Size(max=64)
	public String getStorageBackupId() {
		return storageBackupId;
	}
	/**
	 * スナップショットを指定します。リストア時には、必ず指定する必要があります。
	 * 
	 * @param snapshotId スナップショット。
	 */
	public void setStorageBackupId(String storageBackupId) {
		this.storageBackupId = storageBackupId;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}
	
	public String getFlavor() {
		return flavor;
	}
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}
}
