/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.ApplyCurrentTime;
import com.clustercontrol.cloud.persistence.ApplyUserName;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_instance_backup")
@IdClass(CloudInstanceBackupDao.CloudInstanceBackupPK.class)
public class CloudInstanceBackupDao extends DaoBase {

	public enum RestoreStatus {
		available,
		unavailable
	}
	
	public static class CloudInstanceBackupPK extends Object implements java.io.Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 682905935857533293L;

		private String instanceBackupId;
		private String accountResourceId;
		private String region;

		public CloudInstanceBackupPK() {
		}

		public CloudInstanceBackupPK(String instanceBackupId, String region, String accountResourceId) {
			this.instanceBackupId = instanceBackupId;
			this.accountResourceId = accountResourceId;
			this.region = region;
		}

		public String getInstanceBackupId() {
			return instanceBackupId;
		}
		public void setInstanceBackupId(String instanceBackupId) {
			this.instanceBackupId = instanceBackupId;
		}

		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String AccountResourceId) {
			this.accountResourceId = AccountResourceId;
		}

		public String getRegion()
		{
			return this.region;
		}
		public void setRegion(String region)
		{
			this.region = region;
		}

		public int hashCode() {
			int _hashCode = 0;
			if (this.instanceBackupId != null)
				_hashCode += this.instanceBackupId.hashCode();
			if (this.accountResourceId != null)
				_hashCode += this.accountResourceId.hashCode();
			if (this.region != null)
				_hashCode += this.region.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudInstanceBackupPK))
				return false;

			CloudInstanceBackupPK pk = (CloudInstanceBackupPK) obj;
			boolean eq = true;

			if (this.instanceBackupId != null) {
				eq = eq && this.instanceBackupId.equals(pk.getInstanceBackupId());
			} else
			{
				eq = eq && (pk.getInstanceBackupId() == null);
			}
			if (this.accountResourceId != null) {
				eq = eq
						&& this.accountResourceId.equals(pk
								.getAccountResourceId());
			} else
			{
				eq = eq && (pk.getAccountResourceId() == null);
			}
			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else
			{
				eq = eq && (pk.getRegion() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.instanceBackupId).append('.');
			toStringValue.append(this.accountResourceId).append('.');
			toStringValue.append(this.region).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}
	}
	
	@Embeddable
	public static class BackupedData implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 4522363574206488823L;


		private String facilityId;
		private String facilityName;
		private String facilityDescription;
		private String nodeName;
		private String instanceId;

		public BackupedData() {
		}

		public BackupedData(String facilityId, String facilityName,
				String facilityDescription, String nodeName, String instanceId,
				String zone, String detail) {
			super();
			this.facilityId = facilityId;
			this.facilityName = facilityName;
			this.facilityDescription = facilityDescription;
			this.nodeName = nodeName;
			this.instanceId = instanceId;
		}

		public BackupedData(BackupedData other) {
			this.facilityId = other.getFacilityId();
			this.facilityName = other.getFacilityName();
			this.facilityDescription = other.getFacilityDescription();
			this.nodeName = other.getNodeName();
			this.instanceId = other.getInstanceId();
		}

		@Column(name="facility_id")
		public String getFacilityId()
		{
			return this.facilityId;
		}
		public void setFacilityId( String facilityId )
		{
			this.facilityId = facilityId;
		}
		
		@Column(name="facility_name")
		public String getFacilityName()
		{
			return this.facilityName;
		}
		public void setFacilityName( String facilityName )
		{
			this.facilityName = facilityName;
		}
		
		@Column(name="facility_description")
		public String getFacilityDescription()
		{
			return this.facilityDescription;
		}
		public void setFacilityDescription( String facilityDescription )
		{
			this.facilityDescription = facilityDescription;
		}

		@Column(name="facility_node_name")
		public String getNodeName()
		{
			return this.nodeName;
		}
		public void setNodeName( String nodeName )
		{
			this.nodeName = nodeName;
		}

		@Column(name="instance_id")
		public String getInstanceId()
		{
			return this.instanceId;
		}
		public void setInstanceId( String instanceId )
		{
			this.instanceId = instanceId;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime
					* result
					+ ((facilityDescription == null) ? 0 : facilityDescription
							.hashCode());
			result = prime * result
					+ ((facilityId == null) ? 0 : facilityId.hashCode());
			result = prime * result
					+ ((facilityName == null) ? 0 : facilityName.hashCode());
			result = prime * result
					+ ((instanceId == null) ? 0 : instanceId.hashCode());
			result = prime * result
					+ ((nodeName == null) ? 0 : nodeName.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			BackupedData other = (BackupedData) obj;
			if (facilityDescription == null) {
				if (other.facilityDescription != null)
					return false;
			} else if (!facilityDescription.equals(other.facilityDescription))
				return false;
			if (facilityId == null) {
				if (other.facilityId != null)
					return false;
			} else if (!facilityId.equals(other.facilityId))
				return false;
			if (facilityName == null) {
				if (other.facilityName != null)
					return false;
			} else if (!facilityName.equals(other.facilityName))
				return false;
			if (instanceId == null) {
				if (other.instanceId != null)
					return false;
			} else if (!instanceId.equals(other.instanceId))
				return false;
			if (nodeName == null) {
				if (other.nodeName != null)
					return false;
			} else if (!nodeName.equals(other.nodeName))
				return false;
			return true;
		}

		@Override
		public String toString() {
			return "BackupedData [facilityId=" + facilityId + ", facilityName="
					+ facilityName + ", facilityDescription="
					+ facilityDescription + ", nodeName=" + nodeName
					+ ", instanceId=" + instanceId + "]";
		}
	}
	
	private String instanceBackupId;
	private String cloudServiceId;
	private String region;
	private String accountResourceId;
	private String name;
	private String description;
	private String cloudUserId;
	private BackupedData backupedData;
	private RestoreStatus restoreStatus;
	private Timestamp regDate;
	private String regUser;

	
	public CloudInstanceBackupDao()
	{
	}

	public CloudInstanceBackupDao(String instanceBackupId,
			String cloudServiceId, String region, String accountResourceId,
			String name, String description, String cloudUserId,
			BackupedData backupedData, RestoreStatus restoreStatus,
			Timestamp regDate, String regUser) {
		super();
		this.instanceBackupId = instanceBackupId;
		this.cloudServiceId = cloudServiceId;
		this.region = region;
		this.accountResourceId = accountResourceId;
		this.name = name;
		this.description = description;
		this.cloudUserId = cloudUserId;
		this.backupedData = backupedData;
		this.restoreStatus = restoreStatus;
		this.regDate = regDate;
		this.regUser = regUser;
	}
	
	public CloudInstanceBackupDao( CloudInstanceBackupDao otherData )
	{
		setInstanceBackupId(otherData.getInstanceBackupId());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegion(otherData.getRegion());
		setAccountResourceId(otherData.getAccountResourceId());
		setName(otherData.getName());
		setDescription(otherData.getDescription());
		setCloudUserId(otherData.getCloudUserId());
		setBackupedData(otherData.getBackupedData());
		setRestoreStatus(otherData.getRestoreStatus());
		setRegDate(otherData.getRegDate());
		setRegUser(otherData.getRegUser());
	}

	@Id
	@Column(name="instance_backup_id")
	public String getInstanceBackupId() {
		return instanceBackupId;
	}
	public void setInstanceBackupId(String instanceBackupId) {
		this.instanceBackupId = instanceBackupId;
	}

	@Column(name="cloud_Service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}

	@Id
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String AccountResourceId) {
		this.accountResourceId = AccountResourceId;
	}

	@Id
	@Column(name="region")
	public String getRegion()
	{
		return this.region;
	}
	public void setRegion(String region)
	{
		this.region = region;
	}
	
	@Column(name="name")
	public String getName()
	{
		return this.name;
	}
	public void setName( String name )
	{
		this.name = name;
	}
	
	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription( String description )
	{
		this.description = description;
	}

	@Column(name="cloud_user_id")
	public String getCloudUserId()
	{
		return this.cloudUserId;
	}
	public void setCloudUserId( String cloudUserId )
	{
		this.cloudUserId = cloudUserId;
	}
	
	@Embedded
	public BackupedData getBackupedData() {
		return backupedData;
	}

	public void setBackupedData(BackupedData backupedData) {
		this.backupedData = backupedData;
	}
	
	@Column(name="restore_status")
	@Enumerated(EnumType.STRING)
	public RestoreStatus getRestoreStatus()
	{
		return this.restoreStatus;
	}
	public void setRestoreStatus( RestoreStatus restoreStatus )
	{
		this.restoreStatus = restoreStatus;
	}
	
	@Column(name="reg_date")
	@ApplyCurrentTime(onlyPersist=true)
	public Timestamp getRegDate()
	{
		return this.regDate;
	}
	public void setRegDate( Timestamp regDate )
	{
		this.regDate = regDate;
	}
	
	@Column(name="reg_user")
	@ApplyUserName(onlyPersist=true)
	public String getRegUser()
	{
		return this.regUser;
	}
	public void setRegUser( String regUser )
	{
		this.regUser = regUser;
	}
	
	@Override
	public String toString() {
		return "CloudInstanceBackupDao [instanceBackupId=" + instanceBackupId
				+ ", cloudServiceId=" + cloudServiceId + ", region=" + region
				+ ", accountResourceId=" + accountResourceId + ", name=" + name
				+ ", description=" + description + ", cloudUserId="
				+ cloudUserId + ", backupedData=" + backupedData
				+ ", restoreStatus=" + restoreStatus + ", regDate=" + regDate
				+ ", regUser=" + regUser + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudInstanceBackupDao other = (CloudInstanceBackupDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (backupedData == null) {
			if (other.backupedData != null)
				return false;
		} else if (!backupedData.equals(other.backupedData))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (cloudUserId == null) {
			if (other.cloudUserId != null)
				return false;
		} else if (!cloudUserId.equals(other.cloudUserId))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (instanceBackupId == null) {
			if (other.instanceBackupId != null)
				return false;
		} else if (!instanceBackupId.equals(other.instanceBackupId))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (regDate == null) {
			if (other.regDate != null)
				return false;
		} else if (!regDate.equals(other.regDate))
			return false;
		if (regUser == null) {
			if (other.regUser != null)
				return false;
		} else if (!regUser.equals(other.regUser))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (restoreStatus != other.restoreStatus)
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((backupedData == null) ? 0 : backupedData.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result
				+ ((cloudUserId == null) ? 0 : cloudUserId.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime
				* result
				+ ((instanceBackupId == null) ? 0 : instanceBackupId.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((regDate == null) ? 0 : regDate.hashCode());
		result = prime * result + ((regUser == null) ? 0 : regUser.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((restoreStatus == null) ? 0 : restoreStatus.hashCode());
		return result;
	}

	@Override
	public Object getId() {
		return new CloudInstanceBackupDao.CloudInstanceBackupPK(getInstanceBackupId(), getRegion(), getAccountResourceId());
	}
}
