/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;

//@JsonInclude(JsonInclude.Include.NON_NULL)
@Entity
public class OperationDefinitionDao {
	private String name;
	private AutoControlResourceDefinitionDao ownerResource;
	private String displayName;
	private String description;
	private String scriptPath;
	private List<ParameterDefinitionDao> parameters;

	public OperationDefinitionDao() {
		super();
	}
	
	@Id
	@Column
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@JsonBackReference
    @ManyToOne
	@PrimaryKeyJoinColumn(name = "name")
	public AutoControlResourceDefinitionDao getOwnerResource() {
		return ownerResource;
	}
	public void setOwnerResource(AutoControlResourceDefinitionDao ownerResource) {
		this.ownerResource = ownerResource;
	}
	@Column
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	@Column
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	@JsonManagedReference
	@OneToMany(mappedBy="ownerOperation")
	public List<ParameterDefinitionDao> getParameters() {
		return parameters;
	}
	public void setParameters(List<ParameterDefinitionDao> parameters) {
		this.parameters = parameters;
	}
	@Column
	public String getScriptPath() {
		return scriptPath;
	}
	public void setScriptPath(String scriptPath) {
		this.scriptPath = scriptPath;
	}
}
