/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CreateAccountResourceRequest;
import com.clustercontrol.cloud.bean.ModifyAccountBillingDetailRequest;
import com.clustercontrol.cloud.bean.ModifyAccountResourceRequest;
import com.clustercontrol.fault.InvalidRole;

public interface IAccountResourceOperator {
	CloudAccountResource createCloudAccountResource(CreateAccountResourceRequest request) throws CloudManagerFault, InvalidRole;
	CloudAccountResource modifyCloudAccountResource(ModifyAccountResourceRequest request) throws CloudManagerFault;
	CloudAccountResource modifyAccountBillingDetail(ModifyAccountBillingDetailRequest request) throws CloudManagerFault;
	void removeCloudAccountResource(String accountResourceId) throws CloudManagerFault, InvalidRole;
	
	CloudAccountResource findCloudAccountResource(String accountResourceId) throws CloudManagerFault;
	List<CloudAccountResource> findAllCloudAccountResource() throws CloudManagerFault;

	CloudAccountResource findCloudAccountResourceByUser(String userId, String accountResourceId) throws CloudManagerFault;
	List<CloudAccountResource> findCloudAccountResourcesByUser(String userId) throws CloudManagerFault;
	CloudAccountResource findCloudAccountResourceByCurrentUser(String accountResourceId) throws CloudManagerFault;
	List<CloudAccountResource> findCloudAccountResourcesByCurrentUser() throws CloudManagerFault;

	List<String> getCloudServicesForBilling(String accountResourceId) throws CloudManagerFault;
}
