/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.Messages;


public class CloudMessageUtil {
	public static final String pluginId_cloud = "CLOUD";
	public static final String InternalScopeText = "CLOUD";

	public static void notify_InvalidCronString(
		String monitorId,
		String application,
		String invalidCronString
		) {
		try {
			HinemosUtil.notifyInternalMessage(
					HinemosUtil.Priority.WARNING,
					pluginId_cloud,
					monitorId,
					"",
					InternalScopeText,
					application,
					Messages.messages().getString("cloud.billingalarm.message.invalid_interval_string"),
					Messages.messages().getString("cloud.billingalarm.message.invalid_interval_string.org", new Object[]{invalidCronString}));
		}
		catch (Exception e) {
			Logger.getLogger(CloudMessageUtil.class).warn(e.getMessage(), e);
		}
	}
	
	public static String getExceptionStackTrace(Exception exception) {
		ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
		PrintWriter writer = new PrintWriter(byteArray);
		exception.printStackTrace(writer);
		writer.flush();
		return byteArray.toString();
	}

	public static void notify_Not_Delete_AccountResource_Not_To_Delete_Facility(
		String accountResourceId,
		String facilityId,
		Exception exception
		) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId_cloud,
			accountResourceId,
			"",
			InternalScopeText,
			"AccountResourceOperator",
			Messages.messages().getString("message.account_resource.not_delete_account_resource_not_to_delete_facility"),
			Messages.messages().getString("message.account_resource.not_delete_account_resource_not_to_delete_facility.org", new Object[]{accountResourceId, facilityId}) + "\n" + getExceptionStackTrace(exception));
	}

	public static void notify_Not_Delete_AccountResource_Not_To_Delete_JobUnit(
		String accountResourceId,
		String jobUnitId,
		Exception exception
		) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId_cloud,
			accountResourceId,
			"",
			InternalScopeText,
			"AccountResourceOperator",
			Messages.messages().getString("message.account_resource.not_delete_account_resource_not_to_delete_jobunit"),
			Messages.messages().getString("message.account_resource.not_delete_account_resource_not_to_delete_jobunit.org", new Object[]{accountResourceId, jobUnitId}) + "\n" + getExceptionStackTrace(exception));
	}

	public static void notify_AutoUpadate_Error_InstanceOperator(
			String accountResourceId,
			String instanceId,
			Exception exception
			) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId_cloud,
			accountResourceId,
			Messages.messages().getString("message.autoupdate.error.detail1", new Object[]{accountResourceId, instanceId}),
			InternalScopeText,
			"InstanceOperator",
			Messages.messages().getString("message.autoupdate.error"),
			getExceptionStackTrace(exception));
	}

	public static void notify_AutoUpadate_Error_StorageOperator(
			String accountResourceId,
			String storageId,
			Exception exception
			) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId_cloud,
			accountResourceId,
			Messages.messages().getString("message.autoupdate.error.detail2", new Object[]{accountResourceId, storageId}),
			InternalScopeText,
			"StorageOperator",
			Messages.messages().getString("message.autoupdate.error"),
			getExceptionStackTrace(exception));
	}
}