/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn;

import java.util.HashSet;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.CloudManagerStdService;
import com.clustercontrol.cloud.CloudPlugin;

@NonNullByDefault(false)
public class CloudnManagerStdService extends CloudPlugin {
	public final static String id = CloudnManagerStdService.class.getName();
	
	private static CloudnManagerStdService singleton;
	
	/**
	 * CloudServiceのコンストラクタ
	 */
	public CloudnManagerStdService() {
		super();
		singleton = this;
	}

	@Override
	public Set<String> getDependency() {
		Set<String> set = new HashSet<>();
		set.add(CloudnManagerBaseService.class.getName());
		set.add(CloudManagerStdService.class.getName());
		return set;
	}

	@Override
	public void create() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("creating " + getClass().getSimpleName() + "...");
		
		logger.info("successful in creating " + getClass().getSimpleName() + "...");
	}

	@Override
	public void activate() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("starting " + getClass().getSimpleName() + "...");
		
		logger.info("successful in starting " + getClass().getSimpleName() + "...");
	}

	@Override
	public void deactivate() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("stopping " + getClass().getSimpleName() + "...");
		
		logger.info("successful in stopping " + getClass().getSimpleName() + "...");
	}

	@Override
	public void destroy() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("destroying " + getClass().getSimpleName() + "...");
		
		logger.info("successful in destroying " + getClass().getSimpleName() + "...");
	}
	
	public static CloudnManagerStdService getSingleton() {
		return singleton;
	}

	@Override
	public String getPluginId() {
		return id;
	}

	@Override
	public void initialize() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("initializing " + getClass().getSimpleName() + "...");
		
		logger.info("successful in initializing " + getClass().getSimpleName() + "...");
	}
}