/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudComputeService;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudStorageBackup;
import com.clustercontrol.cloud.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorageBackupManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.List;

public class CloudStorageBackupManager
extends InternalContainer<CloudStorageBackup, com.clustercontrol.ws.cloud.CloudStorageBackup>
implements ICloudStorageBackupManager {
    private AccountResource.Region region;
    private CloudComputeService cloudComputeService;

    public CloudStorageBackupManager(CloudComputeService cloudComputeService) {
        this.cloudComputeService = cloudComputeService;
        this.region = cloudComputeService.getRegion();
    }

    @Override
    public AccountResource.Region getRegion() {
        return this.region;
    }

    public CloudStorageBackup getCloudStorageBackup(String cloudStorageBackupId) {
        for (CloudStorageBackup cloudStorageBackup : this.getComponents()) {
            if (!cloudStorageBackup.getStorageBackupId().equals(cloudStorageBackupId)) continue;
            return cloudStorageBackup;
        }
        return null;
    }

    public CloudStorageBackup[] getCloudStorageBackups() {
        return this.getComponents().toArray(new CloudStorageBackup[0]);
    }

    @Override
    public CloudStorageBackup backupCloudStorage(CreateStorageBackupRequest createStorageBackupRequest) {
        com.clustercontrol.ws.cloud.CreateStorageBackupRequest wsCreateCloudStorageBackupRequest = new com.clustercontrol.ws.cloud.CreateStorageBackupRequest();
        ControlUtil.exportObject(createStorageBackupRequest, wsCreateCloudStorageBackupRequest);
        try {
            com.clustercontrol.ws.cloud.CloudStorageBackup reWsCloudStorageBackup = this.getEndpoint().addStorageBackup(this.getRoleId(), this.region.getRegion(), wsCreateCloudStorageBackupRequest);
            CloudStorageBackup cloudStorageBackup = CloudStorageBackup.createCloudStorageBackup(this, reWsCloudStorageBackup);
            this.getComponents().add(cloudStorageBackup);
            this.fireComponentAdded(cloudStorageBackup);
            return cloudStorageBackup;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudStorageBackup(String storageBackupId) {
        try {
            this.getEndpoint().removeStorageBackup(this.getRoleId(), this.getRegion().getRegion(), storageBackupId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudStorageBackup cloudStorageBackup = this.getCloudStorageBackup(storageBackupId);
        this.getComponents().remove(cloudStorageBackup);
        this.fireComponentRemoved(cloudStorageBackup);
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudStorageBackup> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getStorageBackupsByRegion(this.getRoleId(), this.region.getRegion());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudStorageBackup createComponent(com.clustercontrol.ws.cloud.CloudStorageBackup source) throws CloudModelException {
        CloudStorageBackup cloudStorageBackup = new CloudStorageBackup(this);
        cloudStorageBackup.overwrite(source);
        return cloudStorageBackup;
    }

    @Override
    protected void fireComponentAdded(CloudStorageBackup addedValue) {
        this.fireElementAdded(ICloudStorageBackupManager.p2.cloudStorageBackups, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudStorageBackup removedValue) {
        this.fireElementRemoved(ICloudStorageBackupManager.p2.cloudStorageBackups, removedValue);
    }

    private CloudEndpoint getEndpoint() {
        return this.getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String getRoleId() {
        return this.getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    @Override
    public ICloudComputeService getCloudComputeService() {
        return this.cloudComputeService;
    }
}

